package carmel.value;

import carmel.parser.ParseException;
import carmel.tree.Visitee;
import carmel.tree.Visitor;
import carmel.type.*;

public abstract class Value extends StackEntry implements Visitee {

    public Type type;

    public Value(Type type) {
        super(type == null ? JCVMReferenceType.TYPE : type.getJCVMType());
        this.type = type;
    }

    public Type getType() { return type; }

    public void visit(Visitor v) throws Exception {
        v.visit(this);
    }
}