package carmel.value;

import carmel.type.ShortType;

public class ShortValue extends NumericValue {

    protected short value;

    public ShortValue() {
        this((short) 0);
    }

    public ShortValue(short value) {
        super(ShortType.TYPE);
        this.value = value;
    }

    public short getValue() { return value; }

    public int getValueAsInt() { return value; }

    public void setValue(short value) { this.value = value; }

    public int compareTo(Object o) {
        return value - ((ShortValue) o).value;
    }

    public int hashCode() {
        return value;
    }

    public boolean equals(Object o) {
        return o instanceof ShortValue && value == ((ShortValue) o).value;
    }

    public String toString() { return Short.toString(value); }
}