package carmel.value;

import carmel.type.IntType;

public class IntValue extends NumericValue {

    protected int value;

    public IntValue() {
        this(0);
    }

    public IntValue(int value) {
        super(IntType.TYPE);
        this.value = value;
    }

    public int getValue() { return value; }

    public int getValueAsInt() { return value; }

    public void setValue(int value) { this.value = value; }

    public int compareTo(Object o) {
        return value - ((IntValue) o).value;
    }

    public int hashCode() {
        return value;
    }

    public boolean equals(Object o) {
        return o instanceof IntValue && value == ((IntValue) o).value;
    }

    public String toString() { return Integer.toString(value); }
}