package carmel.value;

import carmel.type.*;

public class ByteValue extends NumericValue {

    protected byte value;

    public ByteValue() {
        this((byte) 0);
    }

    public ByteValue(byte value) {
        super(ByteType.TYPE);
        this.value = value;
    }

    public byte getValue() { return value; }

    public int getValueAsInt() { return value; }

    public void setValue(byte value) { this.value = value; }

    public ShortValue toShort() { return new ShortValue(value); }

    public static ByteValue fromShort(ShortValue v) throws TypeException {
        try {
            return (ByteValue) JCVMByteType.TYPE.createValue(v.value);
        }
        catch (IllegalArgumentException e) {
            throw new TypeException("Value contained in short value is not a byte");
        }
    }

    public int compareTo(Object o) {
        return value - ((ByteValue) o).value;
    }

    public int hashCode() {
        return value;
    }

    public boolean equals(Object o) {
        return o instanceof ByteValue && value == ((ByteValue) o).value;
    }

    public String toString() { return Byte.toString(value); }
}