package carmel.type;

public class VoidType implements ResultType {

    public static final VoidType TYPE = new VoidType();

    private VoidType() {}

    public boolean isAssignableFrom(ResultType type) { return this == type; }

    public void checkAssignableFrom(ResultType type) throws TypeException {
        if (!isAssignableFrom(type)) throw new TypeException(this, type);
    }

    public String getName() { return "void"; }
}