package carmel.type;

public abstract class PrimitiveType implements Type, ComponentType {

    JCVMOperandType jcvmType;

    public PrimitiveType(JCVMOperandType jcvmType) {
        this.jcvmType = jcvmType;
    }

    public JCVMOperandType getJCVMType() { return jcvmType; }

    public boolean isAssignableFrom(ResultType type) {
        return this == type;
    }

    public void checkAssignableFrom(ResultType type) throws TypeException {
        if (!isAssignableFrom(type)) throw new TypeException(this, type);
    }
}