package carmel.type;

public class NullType implements ReferenceType {

    public static final NullType TYPE = new NullType();

    private NullType() {}

    public JCVMOperandType getJCVMType() { return JCVMReferenceType.TYPE; }

    public short getSizeInBytes() { return (short) 2; }

    public boolean isAssignableFrom(ResultType type) { return this == type; }

    public void checkAssignableFrom(ResultType type) throws TypeException {
        if (!isAssignableFrom(type)) throw new TypeException(this, type);
    }

    public String getName() { return "null"; }
}