package carmel.type;

import carmel.value.*;

public class JCVMReferenceType extends JCVMOperandType {

    public static final JCVMReferenceType TYPE = new JCVMReferenceType();

    private JCVMReferenceType() {}

    public Value createDefaultValue() { return NullValue.NULL; }
    public String getName() { return "r"; }

    public boolean applyCondOp(int operator, Value value1, Value value2) throws TypeException {
        checkType(value1);
        checkType(value2);

        switch (operator) {
            case EQ:
                return value1 == value2;
            case NE:
                return value1 != value2;
            default:
                throw new IllegalArgumentException("Unknown or invalid conditional operator: " + operator);
        }
    }

    // this is a bit dirty, but then again, so is the "pop r" instruction instead
    // of "pop ra" which should but doesn't exist
    public void checkType(StackEntry o) throws TypeException {
        try {
            JCVMReturnAddressType.TYPE.checkType(o);
        }
        catch (TypeException e) {
            super.checkType(o);
        }
    }
}