package carmel.type;

import carmel.value.*;

public abstract class JCVMNumericType extends JCVMOperandType {

    public static final int NEG = -1;
    public static final int TO = -2;
    public static final int TOB = -3;
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int REM = 4;
    public static final int AND = 5;
    public static final int OR = 6;
    public static final int XOR = 7;
    public static final int SHL = 8;
    public static final int SHR = 9;
    public static final int USHR = 10;
    public static final int CMP = 11;

    public static final int GT = 0;
    public static final int LT = 1;
    public static final int LE = 3;
    public static final int GE = 4;

    public abstract NumericValue applyUnaryNumOp(int operator, NumericValue value, JCVMNumericType resultType) throws TypeException;
    public abstract NumericValue applyBinaryNumOp(int operator, NumericValue v1, NumericValue v2) throws TypeException;
    public abstract NumericValue createValue(int value) throws IllegalArgumentException;
    public abstract NumericValue to(int value);

    public boolean applyCondOp(int operator, Value value1, Value value2) throws TypeException {
        checkType(value1);
        checkType(value2);

        int result = ((NumericValue) value1).compareTo(value2);

        switch (operator) {
            case EQ:
                return result == 0;
            case NE:
                return result != 0;
            case GT:
                return result > 0;
            case LT:
                return result < 0;
            case LE:
                return result <= 0;
            case GE:
                return result >= 0;
            default:
                throw new IllegalArgumentException("Unknown conditional operator: " + operator);
        }
    }
}