package carmel.type;

import carmel.tree.*;
import java.util.*;

public class ArrayType implements ReferenceType {

    public ComponentType componentType;

    public ArrayType(ComponentType componentType) {
        this.componentType = componentType;
    }

    public JCVMOperandType getJCVMType() { return JCVMReferenceType.TYPE; }

    public ComponentType getComponentType() {
        return componentType;
    }

    public String getName() { return componentType.getName() + "[]"; }

    public boolean isAssignableFrom(ResultType type) {
        return this == type || type == NullType.TYPE || ((type instanceof ArrayType) && componentType.isAssignableFrom(((ArrayType) type).componentType));
    }

    public void checkAssignableFrom(ResultType type) throws TypeException {
        if (!isAssignableFrom(type)) throw new TypeException(this, type);
    }

    public short getSizeInBytes() { return 2; }

    public boolean equals(Object o) {
        return (o instanceof ArrayType) && ((ArrayType)o).getComponentType().equals(componentType);
    }

    public int hashCode() {
        return componentType.hashCode() + 1;
    }
}