package carmel.tree;

import carmel.parser.*;
import carmel.type.*;
import carmel.interpreter.VerificationException;
import carmel.value.*;
import javax.swing.event.EventListenerList;

public class TreeStaticField extends TreeAbstractField {

    protected Value value;
    protected EventListenerList listeners = new EventListenerList();

    public TreeStaticField(Token name, int modifiers, Type type, Value value) {
        super(name, modifiers, type);
        this.value = value;
    }

    public Value getValue() { return value; }

    public void setValue(Value value) throws TypeException {
        type.checkAssignableFrom(value.getType());

        this.value = value;

        fireFieldChanged(value);
    }

    public void addStaticFieldListener(StaticFieldListener l) {
        listeners.add(StaticFieldListener.class, l);
    }

    public void removeStaticFieldListener(StaticFieldListener l) {
        listeners.remove(StaticFieldListener.class, l);
    }

    protected void fireFieldChanged(Value value) {
        StaticFieldEvent e = new StaticFieldEvent(this, value);
        Object[] list = listeners.getListenerList();

        for (int i = list.length - 2; i >= 0; i -= 2)
            if (list[i] == StaticFieldListener.class)
                ((StaticFieldListener) list[i + 1]).fieldChanged(e);
    }

    public void visit(Visitor v) throws Exception {
        v.visit(this);
    }
}