package carmel.tree;

import carmel.parser.Token;
import carmel.type.*;
import carmel.value.*;
import java.util.*;

public class TreeMethod extends TreeConstructorOrMethod {

    public ResultType resultType;
    public MethodID methodID;

    public TreeMethod(Token nameToken, int modifiers, ResultType resultType, List parameterTypes, List exceptions, InstructionBlock instructionBlock) {
        super(nameToken, modifiers, parameterTypes, exceptions, instructionBlock);
        this.resultType = resultType;
    }

    public ResultType getResultType() { return resultType; }

    public MethodID getMethodID() { return methodID; }

    public void visit(Visitor v) throws Exception {
        v.visit(this);
    }
}