package carmel.tree;

import carmel.parser.Token;
import carmel.type.*;
import java.util.*;

public class TreeInterface extends TreeClassOrInterface {

    public TreeInterface(Token name, int modifiers, List interfaces, Map staticFields, List methods) {
        super(name, modifiers, interfaces, staticFields, methods);
    }

    public boolean isAssignableFrom(ResultType type) {
        // are we equal to or a superinterface of type
        return this == type || type == NullType.TYPE || ((type instanceof TreeClassOrInterface) && isAssignableFromCollection(((TreeClassOrInterface) type).getInterfaces()));
    }

    protected boolean isAssignableFromCollection(Collection types) {
        if (types != null) {
            Iterator i = types.iterator();

            while (i.hasNext())
                if (isAssignableFrom((TreeInterface) i.next())) return true;
        }

        return false;
    }

    public void visit(Visitor v) throws Exception {
        v.visit(this);
    }

    public TreeStaticField getStaticField(String name) throws NoSuchFieldException {
        try {
            return getDeclaredStaticField(name);
        }
        catch (NoSuchFieldException e) {
            return getStaticFieldFromInterfaces(name);
        }
    }

    public TreeMethod getMethod(MethodID methodID) throws NoSuchMethodException {
        try {
            return getDeclaredMethod(methodID);
        }
        catch (NoSuchMethodException e) {}

        if (interfaces != null) {
            for (Iterator it = interfaces.iterator(); it.hasNext();) {
                try {
                    return ((TreeInterface) it.next()).getMethod(methodID);
                }
                catch (NoSuchMethodException e) {}
            }
        }

        throw new NoSuchMethodException("Method " + methodID + " not found");
    }
}