package carmel.tree;

import carmel.interpreter.VerificationException;
import carmel.parser.Token;
import carmel.type.*;
import carmel.value.*;

public class TreeField extends TreeAbstractField {

    public int fieldID;

    public TreeField(Token name, int modifiers, Type type) {
        super(name, modifiers, type);
    }

    public Value getValue(ClassValue object) { return object.getFieldValue(fieldID); }
    public void setValue(ClassValue object, Value value) throws TypeException, VerificationException { object.setFieldValue(fieldID, value); }

    public void visit(Visitor v) throws Exception {
        v.visit(this);
    }
}