package carmel.tree;

import carmel.parser.Token;
import java.util.List;

public abstract class TreeConstructorOrMethod extends TreeClassMember {

    public List parameterTypes, exceptions;
    protected List exceptionReferences;
    public InstructionBlock instructionBlock;
    public int localVariableArraySize;

    public TreeConstructorOrMethod(Token nameToken, int modifiers, List parameterTypes, List exceptionReferences, InstructionBlock instructionBlock) {
        super(nameToken, modifiers);
        this.parameterTypes = parameterTypes;
        this.exceptionReferences = exceptionReferences;
        this.instructionBlock = instructionBlock;
    }

    public String getMemberNameWithTypes() {
        return new MethodID(getMemberName(), parameterTypes).toString();
    }

    public String getNameWithTypes() {
        return new MethodID(getName(), parameterTypes).toString();
    }

    public List getParameterTypes() { return parameterTypes; }
    public List getExceptionTypes() { return exceptions; }
}