package carmel.tree;

import carmel.parser.Token;
import carmel.type.*;
import java.util.*;

public abstract class TreeClassOrInterface extends TreeClassOrClassMember implements ReferenceType, ComponentType {

    public TreePackage parentPackage = null;
    List interfaces;
    Map staticFields, methods;
    protected List unmappedMethods;

    public TreeClassOrInterface(Token nameToken, int modifiers, List interfaces, Map staticFields, List methods) {
        super(nameToken, modifiers);
        this.interfaces = interfaces;
        this.staticFields = staticFields;
        unmappedMethods = methods;
    }

    public TreePackage getPackage() { return parentPackage; }

    public String getClassName() { return super.getName(); }

    public String getName() {
        if (parentPackage == null) return "<unknown package>." + getClassName();
        String packageName = parentPackage.getName();
        return (packageName == null) ? getClassName() : packageName + '.' + getClassName();
    }

    public Collection getInterfaces() { return interfaces; }

    public Collection getDeclaredStaticFields() { return staticFields.values(); }

    public TreeStaticField getDeclaredStaticField(String name) throws NoSuchFieldException {
        TreeStaticField field = (TreeStaticField) staticFields.get(name);

        if (field != null) return field;

        throw new NoSuchFieldException("Static field " + name + " not found");
    }

    protected TreeStaticField getStaticFieldFromInterfaces(String name) throws NoSuchFieldException {
        if (interfaces != null) {
            for (Iterator i = interfaces.iterator(); i.hasNext();) {
                try {
                    return ((TreeInterface) i.next()).getStaticField(name);
                }
                catch (NoSuchFieldException e) {}
            }
        }

        throw new NoSuchFieldException("Static field " + name + " not found");
    }

    public abstract TreeStaticField getStaticField(String name) throws NoSuchFieldException;

    public Collection getDeclaredMethods() { return methods.values(); }

    public TreeMethod getDeclaredMethod(MethodID methodID) throws NoSuchMethodException {
        TreeMethod method = (TreeMethod) methods.get(methodID);

        if (method != null) return method;

        throw new NoSuchMethodException("Method " + methodID + " not found");
    }

    public abstract TreeMethod getMethod(MethodID methodID) throws NoSuchMethodException;

//    public Collection getFields() {
//        LinkedList allFields = new LinkedList(getDeclaredFields());
//
//        if (interfaces != null) {
//            Iterator i = interfaces.iterator();
//            while (i.hasNext()) {
//                allFields.addAll(((InterfaceType) i.next()).getFields());
//            }
//        }
//
//        return allFields;
//    }
//
//    public Collection getMethods() {
//        LinkedList allMethods = new LinkedList(getDeclaredMethods());
//
//        if (interfaces != null) {
//            Iterator i = interfaces.iterator();
//            while (i.hasNext()) {
//                allMethods.addAll(((InterfaceType) i.next()).getMethods());
//            }
//        }
//
//        return allMethods;
//    }
//

    public short getSizeInBytes() { return (short) 2; }

    public JCVMOperandType getJCVMType() { return JCVMReferenceType.TYPE; }

    public void checkAssignableFrom(ResultType type) throws TypeException {
        if (!isAssignableFrom(type)) throw new TypeException(this, type);
    }

    // see JLS2 6.6.1
    public boolean isAccessibleFrom(TreeClassOrInterface c) {
        return
            // a class can always access itself
            this == c ||
            // public gives access to everyone
            isPublic() ||
            // otherwise it could only have default access (enforced by parser)
            getPackage() == c.getPackage();
    }
}