package carmel.tree;

import carmel.parser.Token;
import java.lang.reflect.Modifier;

public abstract class TreeClassOrClassMember implements Visitee {

    public Token nameToken;
    protected int modifiers;

    public TreeClassOrClassMember(Token nameToken, int modifiers) {
        this.nameToken = nameToken;
        this.modifiers = modifiers;
    }

    public abstract boolean isAccessibleFrom(TreeClassOrInterface c);

    public String getName() { return nameToken.image; }
    public int getModifiers() { return modifiers; }

    public boolean hasDefaultAccess() { return (modifiers & (Modifier.PUBLIC | Modifier.PROTECTED | Modifier.PRIVATE)) == 0; }

    public boolean isPublic() { return (modifiers & Modifier.PUBLIC) != 0; }
    public boolean isProtected() { return (modifiers & Modifier.PROTECTED) != 0; }
    public boolean isPrivate() { return (modifiers & Modifier.PRIVATE) != 0; }
    public boolean isStatic() { return (modifiers & Modifier.STATIC) != 0; }
    public boolean isFinal() { return (modifiers & Modifier.FINAL) != 0; }
    public boolean isAbstract() { return (modifiers & Modifier.ABSTRACT) != 0; }
    public boolean isNative() { return (modifiers & Modifier.NATIVE) != 0; }

    public int getLineNumber() { return nameToken.beginLine; }
}