package carmel.tree;

import carmel.parser.Token;

public abstract class TreeClassMember extends TreeClassOrClassMember {

    public TreeClassOrInterface parentClass = null;

    public TreeClassMember(Token nameToken, int modifiers) {
        super(nameToken, modifiers);
    }

    public String getName() {
        if (parentClass == null) return getMemberName();
        return parentClass.getName() + '.' + getMemberName();
    }

    public String getMemberName() {
        return super.getName();
    }

    public TreeClassOrInterface getParentClass() { return parentClass; }

    // see JLS2 6.6.1
    public boolean isAccessibleFrom(TreeClassOrInterface c) {
        return
            // a class can always access itself
            parentClass == c || (
                // must not be private, and must be able to access parent class
                (!isPrivate() && parentClass.isAccessibleFrom(c)) && (
                    // public gives access to everyone
                    isPublic() ||
                    // a class in the same package can access protected and default access members
                    (parentClass.getPackage() == c.getPackage() && (isProtected() || hasDefaultAccess())) ||
                    // a subclass (not in the same package) can access protected members
                    (parentClass.isAssignableFrom(c) && isProtected())
                )
            );
    }
}