package carmel.tree;

import carmel.type.JCVMNumericType;

public class NumOpInstruction extends Instruction {

    public int operator;
    public JCVMNumericType operandType, resultType;

    public NumOpInstruction(int operator, JCVMNumericType operandType, JCVMNumericType resultType) {
        this.operator = operator;
        this.operandType = operandType;
        this.resultType = resultType;
    }

    public boolean isUnary() { return operator == JCVMNumericType.NEG || operator == JCVMNumericType.TO; }

    public void visit(InstructionVisitor v) throws Exception {
        v.visit(this);
    }
}