package carmel.tree;

import carmel.parser.Token;
import java.util.*;

public class NameTokenList {

    List nameTokenList;

    public NameTokenList(List nameTokenList) {
        this.nameTokenList = nameTokenList;
    }

    public Token getFirstToken() {
        return (Token) nameTokenList.get(0);
    }

    public Token getLastToken() {
        return (Token) nameTokenList.get(nameTokenList.size() - 1);
    }

    public void add(Token token) {
        nameTokenList.add(token);
    }

    public String getName() {
        Iterator i = nameTokenList.iterator();
        StringBuffer name = new StringBuffer(((Token) i.next()).image);
        while (i.hasNext()) name.append('.').append(((Token) i.next()).image);
        return name.toString();
    }

    public boolean hasPrefix() {
        return nameTokenList.size() > 1;
    }

    public NameTokenList getPrefix() {
        return new NameTokenList(nameTokenList.subList(0, nameTokenList.size() - 1));
    }
}