package carmel.tree;

import carmel.type.Type;
import java.util.*;

public class MethodID {

    public String name;
    public List types;

    public MethodID(String name, List types) {
        this.name = name;
        this.types = types;
    }

    public int hashCode() {
        return name.hashCode() ^ types.hashCode();
    }

    public boolean equals(Object o) {
        return (o instanceof MethodID && ((MethodID) o).name.equals(name) && ((MethodID) o).types.equals(types));
    }

    public String toString() {
        StringBuffer s = new StringBuffer(name).append('(');
        Iterator i = types.iterator();

        if (i.hasNext()) {
            s.append(((Type) i.next()).getName());

            while (i.hasNext())
                s.append(',').append(((Type) i.next()).getName());
        }

        return s.append(')').toString();
    }
}
