package carmel.tree;

/**
 * <p>Title: Carmel Interpreter</p>
 * <p>Description: Interpreter for the Carmel Platform</p>
 * <p>Copyright: Copyright (c) 2002</p>
 * <p>Company: </p>
 * @author Luke Jackson
 * @version 1.0
 */

public interface InstructionVisitor {
    public void visit(NopInstruction i) throws Exception;
    public void visit(PushInstruction i) throws Exception;
    public void visit(PopInstruction i) throws Exception;
    public void visit(DupInstruction i) throws Exception;
    public void visit(SwapInstruction i) throws Exception;
    public void visit(NumOpInstruction i) throws Exception;
    public void visit(LoadInstruction i) throws Exception;
    public void visit(StoreInstruction i) throws Exception;
    public void visit(IncInstruction i) throws Exception;
    public void visit(GotoInstruction i) throws Exception;
    public void visit(IfInstruction i) throws Exception;
    public void visit(LookupSwitchInstruction i) throws Exception;
    public void visit(TableSwitchInstruction i) throws Exception;
    public void visit(NewArrayInstruction i) throws Exception;
    public void visit(NewClassInstruction i) throws Exception;
    public void visit(CheckCastInstruction i) throws Exception;
    public void visit(InstanceOfInstruction i) throws Exception;
    public void visit(GetStaticInstruction i) throws Exception;
    public void visit(PutStaticInstruction i) throws Exception;
    public void visit(GetFieldInstruction i) throws Exception;
    public void visit(PutFieldInstruction i) throws Exception;
    public void visit(InvokeConstructorInstruction i) throws Exception;
    public void visit(InvokeDefiniteMethodInstruction i) throws Exception;
    public void visit(InvokeVirtualInstruction i) throws Exception;
    public void visit(InvokeInterfaceInstruction i) throws Exception;
    public void visit(ReturnInstruction i) throws Exception;
    public void visit(ArrayLengthInstruction i) throws Exception;
    public void visit(ArrayLoadInstruction i) throws Exception;
    public void visit(ArrayStoreInstruction i) throws Exception;
    public void visit(ThrowInstruction i) throws Exception;
    public void visit(JsrInstruction i) throws Exception;
    public void visit(RetInstruction i) throws Exception;
}