package carmel.tree;

import carmel.interpreter.ProgramCounter;
import carmel.value.StackEntry;

public abstract class Instruction extends StackEntry implements ProgramCounter {

    public carmel.parser.Token token;

    // can be null
    public String address;

    // for exception handling
    public int blockIndex;

    public Instruction next;

    public Instruction() {
        super(carmel.type.JCVMReturnAddressType.TYPE);
    }

    public int getLineNumber() { return token.beginLine; }
    public String getAddress() { return address == null ? "_" + blockIndex : address; }
    public ProgramCounter getNextPC() { return next; }

    public String toString() { return getAddress(); }

    public abstract void visit(InstructionVisitor v) throws Exception;
}