package carmel.tree;

import carmel.parser.Token;
import carmel.type.JCVMOperandType;
import carmel.value.Value;

public class IfInstruction extends AddressInstruction {

    public int operator;
    public JCVMOperandType type;
    public Value value;

    public IfInstruction(int operator, JCVMOperandType type, Value value, Token address) {
        super(address);
        this.operator = operator;
        this.type = type;
        this.value = value;
    }

    public void visit(InstructionVisitor v) throws Exception {
        v.visit(this);
    }
}