package carmel.tree;

import carmel.interpreter.ProgramCounter;
import carmel.parser.Token;

public class ExceptionHandler implements ProgramCounter, Visitee {

    public int fromIndex, toIndex;
    public Instruction targetInstruction;
    public TreeClass catchType = null;

    protected int lineNumber;

    protected ClassReference catchTypeReference;
    protected Token fromToken, toToken, targetToken;

    public ExceptionHandler(Token fromToken, Token toToken, Token targetToken, ClassReference catchTypeReference) {
        this.fromToken = fromToken;
        this.toToken = toToken;
        this.targetToken = targetToken;
        this.catchTypeReference = catchTypeReference;
        lineNumber = fromToken.beginLine;
    }

    public int getLineNumber() { return lineNumber; }
    public String getAddress() { return "handler"; }
    public ProgramCounter getNextPC() { return targetInstruction; }

    public void visit(Visitor v) throws Exception {
        v.visit(this);
    }
}