package carmel.tree;

import java.util.*;

public class DefaultInstructionVisitor implements InstructionVisitor {
    public void visit(NopInstruction i) throws Exception {}

    public void visit(PushInstruction i) throws Exception {}
    public void visit(PopInstruction i) throws Exception {}
    public void visit(DupInstruction i) throws Exception {}
    public void visit(SwapInstruction i) throws Exception {}

    public void visit(NumOpInstruction i) throws Exception {}

    protected void visitLocalVariableInstruction(LocalVariableInstruction i) throws Exception {}

    public void visit(LoadInstruction i) throws Exception {
        visitLocalVariableInstruction(i);
    }
    public void visit(StoreInstruction i) throws Exception {
        visitLocalVariableInstruction(i);
    }
    public void visit(IncInstruction i) throws Exception {
        visitLocalVariableInstruction(i);
    }

    protected void visitAddressInstruction(AddressInstruction i) throws Exception {}

    public void visit(GotoInstruction i) throws Exception {
        visitAddressInstruction(i);
    }
    public void visit(IfInstruction i) throws Exception {
        visitAddressInstruction(i);
    }
    public void visit(LookupSwitchInstruction i) throws Exception {
        visitAddressInstruction(i);
    }
    public void visit(TableSwitchInstruction i) throws Exception {
        visitAddressInstruction(i);
    }

    protected void visitTypeInstruction(TypeInstruction i) throws Exception {}

    public void visit(CheckCastInstruction i) throws Exception {
        visitTypeInstruction(i);
    }
    public void visit(InstanceOfInstruction i) throws Exception {
        visitTypeInstruction(i);
    }

    protected void visitStaticFieldInstruction(StaticFieldInstruction i) throws Exception {}

    public void visit(GetStaticInstruction i) throws Exception {
        visitStaticFieldInstruction(i);
    }
    public void visit(PutStaticInstruction i) throws Exception {
        visitStaticFieldInstruction(i);
    }

    protected void visitFieldInstruction(FieldInstruction i) throws Exception {}

    public void visit(GetFieldInstruction i) throws Exception {
        visitFieldInstruction(i);
    }
    public void visit(PutFieldInstruction i) throws Exception {
        visitFieldInstruction(i);
    }

    public void visit(InvokeConstructorInstruction i) throws Exception {}
    public void visit(InvokeDefiniteMethodInstruction i) throws Exception {}
    public void visit(InvokeVirtualInstruction i) throws Exception {}
    public void visit(InvokeInterfaceInstruction i) throws Exception {}

    public void visit(NewArrayInstruction i) throws Exception {}
    public void visit(NewClassInstruction i) throws Exception {}

    public void visit(ReturnInstruction i) throws Exception {}

    public void visit(ArrayLengthInstruction i) throws Exception {}
    public void visit(ArrayLoadInstruction i) throws Exception {}
    public void visit(ArrayStoreInstruction i) throws Exception {}

    public void visit(ThrowInstruction i) throws Exception {}

    public void visit(JsrInstruction i) throws Exception {}
    public void visit(RetInstruction i) throws Exception {}

    protected void visitCollection(Collection c) throws Exception {
        for (Iterator i = c.iterator(); i.hasNext();)
            ((Instruction) i.next()).visit(this);
    }
}