package carmel.tree;

import carmel.type.*;

public class ClassReference extends Reference implements ReferenceType, ComponentType {

    public PackageReference packageReference = null;

    public ClassReference(NameTokenList name) {
        super(name);

        if (name.hasPrefix()) packageReference = new PackageReference(name.getPrefix());
        this.name = name.getLastToken().image;
    }

    public JCVMOperandType getJCVMType() { return JCVMReferenceType.TYPE; }

    public boolean isAssignableFrom(ResultType type) {
        throw new IllegalStateException("Attempt to access unresolved class reference");
    }

    public void checkAssignableFrom(ResultType type) throws TypeException {
        throw new IllegalStateException("Attempt to access unresolved class reference");
    }

    public String getName() {
        return packageReference == null ? name : packageReference.name + '.' + name;
    }

    public short getSizeInBytes() { throw new IllegalStateException("Attempt to access unresolved class reference"); }
}