/* Generated By:JavaCC: Do not edit this line. Parser.java */
package carmel.parser;

import java.lang.reflect.Modifier;
import java.io.*;
import java.util.*;
import carmel.interpreter.CarmelSource;
import carmel.interpreter.Heap;
import carmel.tree.*;
import carmel.type.*;
import carmel.value.*;

public class Parser implements ParserConstants {

    protected Heap heap;
    protected CarmelSource source;

    public Parser(Heap heap, CarmelSource source) throws IOException {
        this(source.openReader());
        this.heap = heap;
        this.source = source;
    }

    public List parsePackages() throws LexOrParseException {
        try {
            return parsePackages_aux();
        }
        catch (TokenMgrError e) {
            if (e.getErrorType() == TokenMgrError.LEXICAL_ERROR)
                throw new LexException(e.getMessage(), source, e.getLine(), e.getColumn());
            throw e;
        }
        catch (ParseException e) {
            e.setSource(source);
            throw e;
        }
    }

    public TreePackage parsePackage() throws LexOrParseException {
        try {
            return parsePackage_aux();
        }
        catch (TokenMgrError e) {
            if (e.getErrorType() == TokenMgrError.LEXICAL_ERROR)
                throw new LexException(e.getMessage(), source, e.getLine(), e.getColumn());
            throw e;
        }
        catch (ParseException e) {
            e.setSource(source);
            throw e;
        }
    }

    protected static int addModifier(int modifiers, Token t, int allowedModifiers) throws ParseException {
        int newModifier = 0;

        switch (t.kind) {
            case PUBLIC:    newModifier = Modifier.PUBLIC;      break;
            case PROTECTED: newModifier = Modifier.PROTECTED;   break;
            case PRIVATE:   newModifier = Modifier.PRIVATE;     break;
            case STATIC:    newModifier = Modifier.STATIC;      break;
            case FINAL:     newModifier = Modifier.FINAL;       break;
            case ABSTRACT:  newModifier = Modifier.ABSTRACT;    break;
            case NATIVE:    newModifier = Modifier.NATIVE;      break;
            default:        throw new Error("Unknown modifier: " + t.image);
        }

        if ((newModifier & allowedModifiers) == 0)
            throw new ParseException("Modifier " + t.image + " not allowed here", t);
        if ((newModifier & modifiers) != 0)
            throw new ParseException("Modifier " + t.image + " declared twice", t);

        modifiers |= newModifier;

        // public, protected and private are mutually exclusive
        if ((modifiers & Modifier.PUBLIC) != 0 && (modifiers & Modifier.PROTECTED) != 0)
            throw new ParseException("Invalid combination of modifiers: public and protected", t);
        if ((modifiers & Modifier.PUBLIC) != 0 && (modifiers & Modifier.PRIVATE) != 0)
            throw new ParseException("Invalid combination of modifiers: public and private", t);
        if ((modifiers & Modifier.PROTECTED) != 0 && (modifiers & Modifier.PRIVATE) != 0)
            throw new ParseException("Invalid combination of modifiers: protected and private", t);

        // abstract cannot also be final, static or native
        if ((modifiers & Modifier.ABSTRACT) != 0) {
            if ((modifiers & Modifier.FINAL) != 0)
                throw new ParseException("Invalid combination of modifiers: abstract and final", t);
            if ((modifiers & Modifier.STATIC) != 0)
                throw new ParseException("Invalid combination of modifiers: abstract and static", t);
            if ((modifiers & Modifier.NATIVE) != 0)
                throw new ParseException("Invalid combination of modifiers: abstract and native", t);
        }

        return modifiers;
    }

/******************************************
* THE CARMEL LANGUAGE GRAMMAR STARTS HERE *
******************************************/

// Program structuring syntax follows.
  final public List parsePackages_aux() throws ParseException {
  List packages = new LinkedList();
  TreePackage p;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PACKAGE:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      p = parsePackageOptionalNameNoEOF();
                                          packages.add(p);
    }
    jj_consume_token(0);
    {if (true) return packages;}
    throw new Error("Missing return statement in function");
  }

  final public TreePackage parsePackage_aux() throws ParseException {
  TreePackage p;
  Token t;
  NameTokenList name;
  byte[] aid;
    t = jj_consume_token(PACKAGE);
    name = name();
    aid = aid();
    jj_consume_token(SEMICOLON);
    p = parsePackageNoNameNoEOF(t, name.getName(), aid);
    jj_consume_token(0);
    {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

  final public TreePackage parsePackageOptionalNameNoEOF() throws ParseException {
  TreePackage p;
  Token t;
  NameTokenList name = null;
  byte[] aid = null;
    t = jj_consume_token(PACKAGE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      name = name();
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      aid = aid();
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    jj_consume_token(SEMICOLON);
    p = parsePackageNoNameNoEOF(t, name == null ? null : name.getName(), aid);
    {if (true) return p;}
    throw new Error("Missing return statement in function");
  }

  final public TreePackage parsePackageNoNameNoEOF(Token token, String name, byte[] aid) throws ParseException {
  ImportDeclaration imports;
  Map classes = new HashMap();
  TreeClass cl;
  Map interfaces = new HashMap();
  TreeInterface in;
  Set nameSet = new HashSet();
    imports = importDeclarations(nameSet);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case CLASS:
      case FINAL:
      case INTERFACE:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
      case SEMICOLON:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_2;
      }
      if (jj_2_1(2147483647)) {
        cl = classDeclaration(nameSet);
                                     classes.put(cl.getClassName(), cl);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case FINAL:
        case INTERFACE:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case STATIC:
          in = interfaceDeclaration(nameSet);
                                         interfaces.put(in.getClassName(), in);
          break;
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          break;
        default:
          jj_la1[4] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    {if (true) return new TreePackage(source, token, name, aid, imports, classes, interfaces);}
    throw new Error("Missing return statement in function");
  }

  final public byte[] aid() throws ParseException {
  Token t;
  List aidBytes = new LinkedList();
  byte[] aid;
  NumericValue value;
    t = jj_consume_token(LBRACE);
    value = numericLiteral(JCVMIntType.TYPE);
                                             aidBytes.add(value);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      jj_consume_token(COMMA);
      value = numericLiteral(JCVMIntType.TYPE);
                                                   aidBytes.add(value);
    }
    jj_consume_token(RBRACE);
    int size = aidBytes.size();
    if (5 > size || size > 16) {if (true) throw new ParseException("Package AID must be between 5 and 16 bytes", t);}
    aid = new byte[size];
    int index = 0;
    for (Iterator i = aidBytes.iterator(); i.hasNext();)
        aid[index++] = (byte) ((IntValue) i.next()).getValue();
    {if (true) return aid;}
    throw new Error("Missing return statement in function");
  }

  final public ImportDeclaration importDeclarations(Set nameSet) throws ParseException {
  Token t;
  NameTokenList name;
  boolean packageImport = false;
  Map classImports = new HashMap();
  Set packageImports = new HashSet();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IMPORT:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      t = jj_consume_token(IMPORT);
      name = name();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        jj_consume_token(DOT);
        jj_consume_token(STAR);
                                           packageImport = true;
        break;
      default:
        jj_la1[7] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
      if (packageImport) {
        if (!packageImports.add(new PackageReference(name))) {if (true) throw new ParseException("Package already imported", t);}
        packageImport = false;
      }
      else {
        if (!name.hasPrefix()) {if (true) throw new ParseException("Import class not fully qualified", t);}
        ClassReference c = new ClassReference(name);
        if (!nameSet.add(c.name))
          {if (true) throw new ParseException("A class called " + c.name + " has already been imported", t);}
        classImports.put(c.name, c);
      }
    }
    {if (true) return new ImportDeclaration(packageImports, classImports);}
    throw new Error("Missing return statement in function");
  }

  final public int modifiers(int allowedModifiers) throws ParseException {
  Token t;
  int modifiers = 0;
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case FINAL:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case STATIC:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PUBLIC:
        t = jj_consume_token(PUBLIC);
        break;
      case PROTECTED:
        t = jj_consume_token(PROTECTED);
        break;
      case PRIVATE:
        t = jj_consume_token(PRIVATE);
        break;
      case ABSTRACT:
        t = jj_consume_token(ABSTRACT);
        break;
      case FINAL:
        t = jj_consume_token(FINAL);
        break;
      case STATIC:
        t = jj_consume_token(STATIC);
        break;
      case NATIVE:
        t = jj_consume_token(NATIVE);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      modifiers = addModifier(modifiers, t, allowedModifiers);
    }
    {if (true) return modifiers;}
    throw new Error("Missing return statement in function");
  }

// Declaration syntax follows.
  final public TreeClass classDeclaration(Set nameSet) throws ParseException {
  int modifiers;
  Token name;
  ClassReference superClass = null;
  List interfaces = null;

  Map staticFields = new HashMap();
  Map fields = new HashMap();
  List constructors = new LinkedList();
  List methods = new LinkedList();

  int memberModifiers;
    modifiers = modifiers(Modifier.ABSTRACT | Modifier.FINAL | Modifier.PUBLIC);
    jj_consume_token(CLASS);
    name = identifier();
                        if (!nameSet.add(name.image)) {if (true) throw new ParseException("Duplicate definition of " + name.image, name);}
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      superClass = classReference();
      break;
    default:
      jj_la1[10] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IMPLEMENTS:
      jj_consume_token(IMPLEMENTS);
      interfaces = classReferenceList();
      break;
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case FINAL:
      case INT:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case VOID:
      case NOP:
      case PUSH:
      case POP:
      case DUP:
      case SWAP:
      case NUMOP:
      case LOAD:
      case STORE:
      case INC:
      case LOOKUPSWITCH:
      case TABLESWITCH:
      case CHECKCAST:
      case GETSTATIC:
      case PUTSTATIC:
      case GETFIELD:
      case PUTFIELD:
      case INVOKEDEFINITE:
      case INVOKEINTERFACE:
      case INVOKEVIRTUAL:
      case ARRAYLENGTH:
      case ARRAYLOAD:
      case ARRAYSTORE:
      case JSR:
      case RET:
      case R:
      case B:
      case S:
      case I:
      case GT:
      case LT:
      case EQ:
      case LE:
      case GE:
      case NE:
      case NEG:
      case ADD:
      case SUB:
      case MUL:
      case DIV:
      case REM:
      case AND:
      case OR:
      case XOR:
      case SHL:
      case SHR:
      case USHR:
      case TO:
      case CMP:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_6;
      }
      if (jj_2_2(2147483647)) {
        constructorDeclaration(constructors, name.image);
      } else if (jj_2_3(2147483647)) {
        memberModifiers = modifiers(Modifier.PUBLIC | Modifier.PROTECTED | Modifier.PRIVATE | Modifier.STATIC | Modifier.ABSTRACT | Modifier.FINAL | Modifier.NATIVE);
        unmodifiedMethodDeclaration(methods, memberModifiers);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case FINAL:
        case INT:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case NOP:
        case PUSH:
        case POP:
        case DUP:
        case SWAP:
        case NUMOP:
        case LOAD:
        case STORE:
        case INC:
        case LOOKUPSWITCH:
        case TABLESWITCH:
        case CHECKCAST:
        case GETSTATIC:
        case PUTSTATIC:
        case GETFIELD:
        case PUTFIELD:
        case INVOKEDEFINITE:
        case INVOKEINTERFACE:
        case INVOKEVIRTUAL:
        case ARRAYLENGTH:
        case ARRAYLOAD:
        case ARRAYSTORE:
        case JSR:
        case RET:
        case R:
        case B:
        case S:
        case I:
        case GT:
        case LT:
        case EQ:
        case LE:
        case GE:
        case NE:
        case NEG:
        case ADD:
        case SUB:
        case MUL:
        case DIV:
        case REM:
        case AND:
        case OR:
        case XOR:
        case SHL:
        case SHR:
        case USHR:
        case TO:
        case CMP:
        case IDENTIFIER:
          memberModifiers = modifiers(Modifier.PUBLIC | Modifier.PROTECTED | Modifier.PRIVATE | Modifier.STATIC | Modifier.FINAL);
          unmodifiedFieldDeclaration(staticFields, fields, memberModifiers);
          break;
        default:
          jj_la1[13] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    jj_consume_token(RBRACE);
    {if (true) return new TreeClass(name, modifiers, superClass, interfaces, staticFields, fields, constructors, methods);}
    throw new Error("Missing return statement in function");
  }

  final public TreeInterface interfaceDeclaration(Set nameSet) throws ParseException {
  int modifiers;
  Token name;
  List interfaces = null;
  Map fields = new HashMap();
  List methods = new LinkedList();
    modifiers = modifiers(Modifier.ABSTRACT | Modifier.PUBLIC);
    jj_consume_token(INTERFACE);
    name = identifier();
                        if (!nameSet.add(name.image)) {if (true) throw new ParseException("Duplicate definition of " + name.image, name);}
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EXTENDS:
      jj_consume_token(EXTENDS);
      interfaces = classReferenceList();
      break;
    default:
      jj_la1[14] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ABSTRACT:
      case BOOLEAN:
      case BYTE:
      case FINAL:
      case INT:
      case NATIVE:
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
      case SHORT:
      case STATIC:
      case VOID:
      case NOP:
      case PUSH:
      case POP:
      case DUP:
      case SWAP:
      case NUMOP:
      case LOAD:
      case STORE:
      case INC:
      case LOOKUPSWITCH:
      case TABLESWITCH:
      case CHECKCAST:
      case GETSTATIC:
      case PUTSTATIC:
      case GETFIELD:
      case PUTFIELD:
      case INVOKEDEFINITE:
      case INVOKEINTERFACE:
      case INVOKEVIRTUAL:
      case ARRAYLENGTH:
      case ARRAYLOAD:
      case ARRAYSTORE:
      case JSR:
      case RET:
      case R:
      case B:
      case S:
      case I:
      case GT:
      case LT:
      case EQ:
      case LE:
      case GE:
      case NE:
      case NEG:
      case ADD:
      case SUB:
      case MUL:
      case DIV:
      case REM:
      case AND:
      case OR:
      case XOR:
      case SHL:
      case SHR:
      case USHR:
      case TO:
      case CMP:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[15] = jj_gen;
        break label_7;
      }
      if (jj_2_4(2147483647)) {
        modifiers(Modifier.PUBLIC | Modifier.ABSTRACT);
        unmodifiedMethodDeclaration(methods, Modifier.PUBLIC | Modifier.ABSTRACT);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ABSTRACT:
        case BOOLEAN:
        case BYTE:
        case FINAL:
        case INT:
        case NATIVE:
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
        case SHORT:
        case STATIC:
        case NOP:
        case PUSH:
        case POP:
        case DUP:
        case SWAP:
        case NUMOP:
        case LOAD:
        case STORE:
        case INC:
        case LOOKUPSWITCH:
        case TABLESWITCH:
        case CHECKCAST:
        case GETSTATIC:
        case PUTSTATIC:
        case GETFIELD:
        case PUTFIELD:
        case INVOKEDEFINITE:
        case INVOKEINTERFACE:
        case INVOKEVIRTUAL:
        case ARRAYLENGTH:
        case ARRAYLOAD:
        case ARRAYSTORE:
        case JSR:
        case RET:
        case R:
        case B:
        case S:
        case I:
        case GT:
        case LT:
        case EQ:
        case LE:
        case GE:
        case NE:
        case NEG:
        case ADD:
        case SUB:
        case MUL:
        case DIV:
        case REM:
        case AND:
        case OR:
        case XOR:
        case SHL:
        case SHR:
        case USHR:
        case TO:
        case CMP:
        case IDENTIFIER:
          modifiers(Modifier.PUBLIC | Modifier.STATIC | Modifier.FINAL);
          unmodifiedFieldDeclaration(fields, null, Modifier.PUBLIC | Modifier.STATIC | Modifier.FINAL);
          break;
        default:
          jj_la1[16] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    jj_consume_token(RBRACE);
    {if (true) return new TreeInterface(name, modifiers, interfaces, fields, methods);}
    throw new Error("Missing return statement in function");
  }

  final public void unmodifiedFieldDeclaration(Map staticFields, Map fields, int modifiers) throws ParseException {
  Type type;
    type = type();
    fieldDeclarator(staticFields, fields, modifiers, type);
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[17] = jj_gen;
        break label_8;
      }
      jj_consume_token(COMMA);
      fieldDeclarator(staticFields, fields, modifiers, type);
    }
    jj_consume_token(SEMICOLON);
  }

  final public void fieldDeclarator(Map staticFields, Map fields, int modifiers, Type type) throws ParseException {
  Token name, t = null;
  Value initialValue = null;
    name = identifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      t = jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
      try {
        type = new ArrayType((ComponentType) type);
      }
      catch (ClassCastException e) {
        {if (true) throw new ParseException("Field is declared twice as an array", t);}
      }
      break;
    default:
      jj_la1[18] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGN:
      t = jj_consume_token(ASSIGN);
      initialValue = fieldInitializer(type);
      break;
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    if ((modifiers & Modifier.STATIC) == 0) {
      if (initialValue != null) {if (true) throw new ParseException("Initialiser not allowed non-static field", t);}

      if (staticFields.containsKey(name.image) || (fields.put(name.image, new TreeField(name, modifiers, type)) != null))
        {if (true) throw new ParseException("Duplicate definition of field " + name.image, name);}
    }
    else {
      if (((modifiers & Modifier.FINAL) != 0) && (initialValue == null)) {if (true) throw new ParseException("Uninitialised static final field", name);}

      if (fields.containsKey(name.image) || (staticFields.put(name.image, new TreeStaticField(name, modifiers, type, initialValue)) != null))
        {if (true) throw new ParseException("Duplicate definition of field " + name.image, name);}
    }
  }

  final public Value fieldInitializer(Type type) throws ParseException {
  Value v;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      v = arrayInitializer(type);
      break;
    case FALSE:
    case TRUE:
    case DECIMAL_NUMERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case LPAREN:
    case MINUS:
      v = primitiveLiteral(type);
      break;
    case NULL:
      v = nullLiteral(type.getJCVMType());
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return v;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayValue arrayInitializer(Type type) throws ParseException {
  PrimitiveType componentType;
  List values = new LinkedList();
  PrimitiveValue value;
  Token t;
    t = jj_consume_token(LBRACE);
    try {
      componentType = (PrimitiveType) ((ArrayType) type).getComponentType();
    }
    catch (ClassCastException e) {
      {if (true) throw new ParseException("Invalid array initializer", t);}
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FALSE:
    case TRUE:
    case DECIMAL_NUMERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case LPAREN:
    case MINUS:
      value = primitiveLiteral(componentType);
                                              values.add(value);
      label_9:
      while (true) {
        if (jj_2_5(2)) {
          ;
        } else {
          break label_9;
        }
        jj_consume_token(COMMA);
        value = primitiveLiteral(componentType);
                                                                 values.add(value);
      }
      break;
    default:
      jj_la1[21] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COMMA:
      jj_consume_token(COMMA);
      break;
    default:
      jj_la1[22] = jj_gen;
      ;
    }
    jj_consume_token(RBRACE);
    {if (true) return new ArrayValue(heap, (ArrayType) type, values);}
    throw new Error("Missing return statement in function");
  }

  final public void unmodifiedMethodDeclaration(List methods, int modifiers) throws ParseException {
  ResultType resultType;
  List parameterTypes;
  Token name, t;
  List exceptions = null;
  InstructionBlock instructionBlock = null;
    resultType = resultType();
    name = identifier();
    parameterTypes = formalParameters();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      t = jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
      try {
        resultType = new ArrayType((ComponentType) resultType);
      }
      catch (ClassCastException e) {
        if (resultType instanceof VoidType)
          {if (true) throw new ParseException("Array of void not allowed", t);}
        else
          {if (true) throw new ParseException("Method return type declared twice as array", t);}
      }
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROWS:
      jj_consume_token(THROWS);
      exceptions = classReferenceList();
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACE:
      t = jj_consume_token(LBRACE);
              if ((modifiers & (Modifier.ABSTRACT | Modifier.NATIVE)) != 0) {if (true) throw new ParseException("Body not allowed for abstract or native method", t);}
      instructionBlock = instructionBlock();
      jj_consume_token(RBRACE);
      break;
    case SEMICOLON:
      t = jj_consume_token(SEMICOLON);
              if ((modifiers & (Modifier.ABSTRACT | Modifier.NATIVE)) == 0) {if (true) throw new ParseException("Body required for non-abstract, non-native method", t);}
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    methods.add(new TreeMethod(name, modifiers, resultType, parameterTypes, exceptions, instructionBlock));
  }

  final public List formalParameters() throws ParseException {
  List parameterTypes = new ArrayList();
  Set names = new HashSet();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case FINAL:
    case INT:
    case SHORT:
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      formalParameter(names, parameterTypes);
      label_10:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_10;
        }
        jj_consume_token(COMMA);
        formalParameter(names, parameterTypes);
      }
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    {if (true) return parameterTypes;}
    throw new Error("Missing return statement in function");
  }

  final public void formalParameter(Set names, List parameterTypes) throws ParseException {
  Type type;
  Token name, t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FINAL:
      jj_consume_token(FINAL);
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    type = type();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      name = identifier();
                          if (!names.add(name.image)) {if (true) throw new ParseException("Duplicate definition of parameter " + name.image, name);}
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        t = jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
        try {
          type = new ArrayType((ComponentType) type);
        }
        catch (ClassCastException e) {
          {if (true) throw new ParseException("Parameter type declared twice as an array", t);}
        }
        break;
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[30] = jj_gen;
      ;
    }
    parameterTypes.add(type);
  }

  final public void constructorDeclaration(List constructors, String className) throws ParseException {
  int modifiers;
  Token name;
  List parameterTypes;
  List exceptions = null;
  InstructionBlock instructionBlock;
    modifiers = modifiers(Modifier.PUBLIC | Modifier.PROTECTED | Modifier.PRIVATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOID:
      jj_consume_token(VOID);
      name = jj_consume_token(INIT);
      break;
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      name = identifier();
                            if (!name.image.equals(className)) {if (true) throw new ParseException("Method return type missing", name);}
      break;
    default:
      jj_la1[31] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    parameterTypes = formalParameters();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROWS:
      jj_consume_token(THROWS);
      exceptions = classReferenceList();
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
    jj_consume_token(LBRACE);
    instructionBlock = instructionBlock();
    jj_consume_token(RBRACE);
    constructors.add(new TreeConstructor(name, modifiers, parameterTypes, exceptions, instructionBlock));
  }

// Type, name and expression syntax follows.
  final public ResultType resultType() throws ParseException {
  ResultType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOID:
      jj_consume_token(VOID);
           {if (true) return VoidType.TYPE;}
      break;
    case BOOLEAN:
    case BYTE:
    case INT:
    case SHORT:
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      type = type();
                  {if (true) return type;}
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Type type() throws ParseException {
  ComponentType type;
    type = componentType();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LBRACKET:
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
              {if (true) return new ArrayType(type);}
      break;
    default:
      jj_la1[34] = jj_gen;
      ;
    }
    {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayType arrayType() throws ParseException {
  ComponentType type;
    type = componentType();
    jj_consume_token(LBRACKET);
    jj_consume_token(RBRACKET);
                                   {if (true) return new ArrayType(type);}
    throw new Error("Missing return statement in function");
  }

  final public ComponentType componentType() throws ParseException {
  ComponentType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case INT:
    case SHORT:
      type = primitiveType();
      break;
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      type = classReference();
      break;
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return type;}
    throw new Error("Missing return statement in function");
  }

  final public ClassReference classReference() throws ParseException {
  NameTokenList name;
    name = name();
                  {if (true) return new ClassReference(name);}
    throw new Error("Missing return statement in function");
  }

  final public ReferenceType referenceType() throws ParseException {
  ComponentType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case INT:
    case SHORT:
      type = primitiveType();
      jj_consume_token(LBRACKET);
      jj_consume_token(RBRACKET);
                                       {if (true) return new ArrayType(type);}
      break;
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      type = classReference();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LBRACKET:
        jj_consume_token(LBRACKET);
        jj_consume_token(RBRACKET);
                                          {if (true) return new ArrayType(type);}
        break;
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return (ReferenceType) type;}
    throw new Error("Missing return statement in function");
  }

  final public PrimitiveType primitiveType() throws ParseException {
  NumericType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
      jj_consume_token(BOOLEAN);
              {if (true) return BooleanType.TYPE;}
      break;
    case BYTE:
    case INT:
    case SHORT:
      type = primitiveNumericType();
                                  {if (true) return type;}
      break;
    default:
      jj_la1[38] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public NumericType primitiveNumericType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BYTE:
      jj_consume_token(BYTE);
              {if (true) return ByteType.TYPE;}
      break;
    case SHORT:
      jj_consume_token(SHORT);
              {if (true) return ShortType.TYPE;}
      break;
    case INT:
      jj_consume_token(INT);
              {if (true) return IntType.TYPE;}
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// VERY IMPORTANT:
//   if you add or remove a token from this production, make sure to change
//   the ParseException constructor, as well as this comment, to reflect that
//   there are no longer **48** alternate productions
  final public Token identifier() throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      t = jj_consume_token(IDENTIFIER);
      break;
    case NOP:
      t = jj_consume_token(NOP);
      break;
    case PUSH:
      t = jj_consume_token(PUSH);
      break;
    case POP:
      t = jj_consume_token(POP);
      break;
    case DUP:
      t = jj_consume_token(DUP);
      break;
    case SWAP:
      t = jj_consume_token(SWAP);
      break;
    case NUMOP:
      t = jj_consume_token(NUMOP);
      break;
    case LOAD:
      t = jj_consume_token(LOAD);
      break;
    case STORE:
      t = jj_consume_token(STORE);
      break;
    case INC:
      t = jj_consume_token(INC);
      break;
    case LOOKUPSWITCH:
      t = jj_consume_token(LOOKUPSWITCH);
      break;
    case TABLESWITCH:
      t = jj_consume_token(TABLESWITCH);
      break;
    case CHECKCAST:
      t = jj_consume_token(CHECKCAST);
      break;
    case GETSTATIC:
      t = jj_consume_token(GETSTATIC);
      break;
    case PUTSTATIC:
      t = jj_consume_token(PUTSTATIC);
      break;
    case GETFIELD:
      t = jj_consume_token(GETFIELD);
      break;
    case PUTFIELD:
      t = jj_consume_token(PUTFIELD);
      break;
    case INVOKEDEFINITE:
      t = jj_consume_token(INVOKEDEFINITE);
      break;
    case INVOKEINTERFACE:
      t = jj_consume_token(INVOKEINTERFACE);
      break;
    case INVOKEVIRTUAL:
      t = jj_consume_token(INVOKEVIRTUAL);
      break;
    case ARRAYLENGTH:
      t = jj_consume_token(ARRAYLENGTH);
      break;
    case ARRAYLOAD:
      t = jj_consume_token(ARRAYLOAD);
      break;
    case ARRAYSTORE:
      t = jj_consume_token(ARRAYSTORE);
      break;
    case JSR:
      t = jj_consume_token(JSR);
      break;
    case RET:
      t = jj_consume_token(RET);
      break;
    case R:
      t = jj_consume_token(R);
      break;
    case B:
      t = jj_consume_token(B);
      break;
    case S:
      t = jj_consume_token(S);
      break;
    case I:
      t = jj_consume_token(I);
      break;
    case GT:
      t = jj_consume_token(GT);
      break;
    case LT:
      t = jj_consume_token(LT);
      break;
    case EQ:
      t = jj_consume_token(EQ);
      break;
    case LE:
      t = jj_consume_token(LE);
      break;
    case GE:
      t = jj_consume_token(GE);
      break;
    case NE:
      t = jj_consume_token(NE);
      break;
    case NEG:
      t = jj_consume_token(NEG);
      break;
    case ADD:
      t = jj_consume_token(ADD);
      break;
    case SUB:
      t = jj_consume_token(SUB);
      break;
    case MUL:
      t = jj_consume_token(MUL);
      break;
    case DIV:
      t = jj_consume_token(DIV);
      break;
    case REM:
      t = jj_consume_token(REM);
      break;
    case AND:
      t = jj_consume_token(AND);
      break;
    case OR:
      t = jj_consume_token(OR);
      break;
    case XOR:
      t = jj_consume_token(XOR);
      break;
    case SHL:
      t = jj_consume_token(SHL);
      break;
    case SHR:
      t = jj_consume_token(SHR);
      break;
    case USHR:
      t = jj_consume_token(USHR);
      break;
    case TO:
      t = jj_consume_token(TO);
      break;
    case CMP:
      t = jj_consume_token(CMP);
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

  final public FieldReference fieldName() throws ParseException {
  NameTokenList name;
    name = name();
                  {if (true) return new FieldReference(name);}
    throw new Error("Missing return statement in function");
  }

  final public List methodTypes() throws ParseException {
  List types = new ArrayList();
  Type type;
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case BOOLEAN:
    case BYTE:
    case INT:
    case SHORT:
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      type = type();
                        types.add(type);
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[41] = jj_gen;
          break label_11;
        }
        jj_consume_token(COMMA);
        type = type();
                                                                 types.add(type);
      }
      break;
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    {if (true) return types;}
    throw new Error("Missing return statement in function");
  }

  final public void constructorReferenceLookAhead() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      name();
      jj_consume_token(DOT);
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
    jj_consume_token(INIT);
  }

  final public ConstructorReference constructorReference() throws ParseException {
  NameTokenList name = null;
  List types;
  Token initToken;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOP:
    case PUSH:
    case POP:
    case DUP:
    case SWAP:
    case NUMOP:
    case LOAD:
    case STORE:
    case INC:
    case LOOKUPSWITCH:
    case TABLESWITCH:
    case CHECKCAST:
    case GETSTATIC:
    case PUTSTATIC:
    case GETFIELD:
    case PUTFIELD:
    case INVOKEDEFINITE:
    case INVOKEINTERFACE:
    case INVOKEVIRTUAL:
    case ARRAYLENGTH:
    case ARRAYLOAD:
    case ARRAYSTORE:
    case JSR:
    case RET:
    case R:
    case B:
    case S:
    case I:
    case GT:
    case LT:
    case EQ:
    case LE:
    case GE:
    case NE:
    case NEG:
    case ADD:
    case SUB:
    case MUL:
    case DIV:
    case REM:
    case AND:
    case OR:
    case XOR:
    case SHL:
    case SHR:
    case USHR:
    case TO:
    case CMP:
    case IDENTIFIER:
      name = name();
      jj_consume_token(DOT);
      break;
    default:
      jj_la1[44] = jj_gen;
      ;
    }
    initToken = jj_consume_token(INIT);
    types = methodTypes();
    if (name == null) name = new NameTokenList(new LinkedList());
    name.add(initToken);
    {if (true) return new ConstructorReference(name, types);}
    throw new Error("Missing return statement in function");
  }

  final public MethodReference methodReference() throws ParseException {
  NameTokenList name;
  List types;
    name = name();
    types = methodTypes();
    {if (true) return new MethodReference(name, types);}
    throw new Error("Missing return statement in function");
  }

  final public NameTokenList name() throws ParseException {
  List names = new LinkedList();
  Token t;
    t = identifier();
                     names.add(t);
    label_12:
    while (true) {
      if (jj_2_6(2)) {
        ;
      } else {
        break label_12;
      }
      jj_consume_token(DOT);
      t = identifier();
                                        names.add(t);
    }
    {if (true) return new NameTokenList(names);}
    throw new Error("Missing return statement in function");
  }

  final public List classReferenceList() throws ParseException {
  List classes = new LinkedList();
  ClassReference c;
    c = classReference();
                         classes.add(c);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[45] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
      c = classReference();
                               classes.add(c);
    }
    {if (true) return classes;}
    throw new Error("Missing return statement in function");
  }

  final public PrimitiveValue primitiveLiteral(Type type) throws ParseException {
  PrimitiveValue value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL_NUMERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case LPAREN:
    case MINUS:
      value = numericLiteral(type.getJCVMType());
      break;
    case FALSE:
    case TRUE:
      value = booleanLiteral(type);
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                                                                                  {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public NumericValue numericLiteral(JCVMType type) throws ParseException {
  Token minusToken = null, t;
  String s;
  int radix;
  NumericType castType = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      castType = primitiveNumericType();
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[47] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      minusToken = jj_consume_token(MINUS);
      break;
    default:
      jj_la1[48] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL_NUMERAL:
      t = jj_consume_token(DECIMAL_NUMERAL);
                              radix = 10; s = t.image;
      break;
    case HEX_LITERAL:
      t = jj_consume_token(HEX_LITERAL);
                          radix = 16; s = t.image.substring(2);
      break;
    case OCTAL_LITERAL:
      t = jj_consume_token(OCTAL_LITERAL);
                            radix = 8; s = t.image.substring(1);
      break;
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    try {
      int value = minusToken == null ? Integer.parseInt(s, radix) : Integer.parseInt("-" + s, radix);

      if (castType != null) {
        JCVMNumericType castJCVMType = (JCVMNumericType) castType.getJCVMType();
        {if (true) return castJCVMType.applyUnaryNumOp(JCVMNumericType.TO, castJCVMType.to(value), (JCVMNumericType) type);}
      }

      {if (true) return ((JCVMNumericType) type).createValue(value);}
    }
    catch (ClassCastException e) {
      {if (true) throw new ParseException("Number not expected here", minusToken == null ? t : minusToken);}
    }
    catch (NumberFormatException e) {
      {if (true) throw new ParseException("Invalid number: " + e.getMessage(), minusToken == null ? t : minusToken);}
    }
    catch (IllegalArgumentException e) {
      {if (true) throw new ParseException(e.getMessage(), minusToken == null ? t : minusToken);}
    }
    catch (TypeException e) {
      {if (true) throw new InternalError("Not expecting a type exception from applyUnaryNumOp");}
    }
    throw new Error("Missing return statement in function");
  }

  final public ByteValue booleanLiteral(Type type) throws ParseException {
  Token t;
  ByteValue value;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      t = jj_consume_token(TRUE);
                  value = new ByteValue((byte) 1);
      break;
    case FALSE:
      t = jj_consume_token(FALSE);
                  value = new ByteValue((byte) 0);
      break;
    default:
      jj_la1[50] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (type == BooleanType.TYPE) {if (true) return value;}
    {if (true) throw new ParseException("Boolean value not allowed here", t);}
    throw new Error("Missing return statement in function");
  }

  final public NullValue nullLiteral(JCVMType type) throws ParseException {
  Token t;
    t = jj_consume_token(NULL);
    if (type == JCVMReferenceType.TYPE) {if (true) return NullValue.NULL;}
    {if (true) throw new ParseException("Null only allowed for reference types", t);}
    throw new Error("Missing return statement in function");
  }

// cannot factor with decimalNumeral as -Integer.MIN_VALUE > Integer.MAX_VALUE
  final public int integerConstant() throws ParseException {
  Token minusToken = null, t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      minusToken = jj_consume_token(MINUS);
      break;
    default:
      jj_la1[51] = jj_gen;
      ;
    }
    t = jj_consume_token(DECIMAL_NUMERAL);
    try {
      {if (true) return minusToken == null ? Integer.parseInt(t.image) : Integer.parseInt("-" + t.image);}
    }
    catch (NumberFormatException e) {
      {if (true) throw new ParseException("Invalid number: " + e.getMessage(), minusToken == null ? t : minusToken);}
    }
    throw new Error("Missing return statement in function");
  }

  final public int decimalNumeral() throws ParseException {
  Token t;
    t = jj_consume_token(DECIMAL_NUMERAL);
    try {
      {if (true) return Integer.parseInt(t.image);}
    }
    catch (NumberFormatException e) {
      {if (true) throw new ParseException("Invalid number: " + e.getMessage(), t);}
    }
    throw new Error("Missing return statement in function");
  }

  final public Token address() throws ParseException {
  Token t;
    t = jj_consume_token(DECIMAL_NUMERAL);
                          {if (true) return t;}
    throw new Error("Missing return statement in function");
  }

// Instruction syntax follows.
  final public InstructionBlock instructionBlock() throws ParseException {
  List instructions = new ArrayList();
  Instruction firstInstruction, prevInstruction, instruction;
  int index = 0;

  Map addressMap = new HashMap();
  Token address;

  List handlers = new LinkedList();
  Token from, to, target;
  ClassReference catchType = null;
    //  "{"
      firstInstruction = instruction(addressMap, index++);
                                                        prevInstruction = firstInstruction;
    label_14:
    while (true) {
      if (jj_2_7(2)) {
        ;
      } else {
        break label_14;
      }
      instruction = instruction(addressMap, index++);
                                                     prevInstruction = (prevInstruction.next = instruction);
    }
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMAL_NUMERAL:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_15;
      }
      from = address();
      jj_consume_token(MINUS);
      to = address();
      jj_consume_token(COLON);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
            catchType = null;
        break;
      case NOP:
      case PUSH:
      case POP:
      case DUP:
      case SWAP:
      case NUMOP:
      case LOAD:
      case STORE:
      case INC:
      case LOOKUPSWITCH:
      case TABLESWITCH:
      case CHECKCAST:
      case GETSTATIC:
      case PUTSTATIC:
      case GETFIELD:
      case PUTFIELD:
      case INVOKEDEFINITE:
      case INVOKEINTERFACE:
      case INVOKEVIRTUAL:
      case ARRAYLENGTH:
      case ARRAYLOAD:
      case ARRAYSTORE:
      case JSR:
      case RET:
      case R:
      case B:
      case S:
      case I:
      case GT:
      case LT:
      case EQ:
      case LE:
      case GE:
      case NE:
      case NEG:
      case ADD:
      case SUB:
      case MUL:
      case DIV:
      case REM:
      case AND:
      case OR:
      case XOR:
      case SHL:
      case SHR:
      case USHR:
      case TO:
      case CMP:
      case IDENTIFIER:
        catchType = classReference();
        break;
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(RIGHTARROW);
      target = address();
      handlers.add(new ExceptionHandler(from, to, target, catchType));
    }
    {if (true) return new InstructionBlock(firstInstruction, handlers, addressMap);}
    throw new Error("Missing return statement in function");
  }

  final public Instruction instruction(Map addressMap, int index) throws ParseException {
  Token address;
  Instruction i;
    address = address();
    jj_consume_token(COLON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NOP:
      i = nopInstruction();
      break;
    case PUSH:
      i = pushInstruction();
      break;
    case POP:
      i = popInstruction();
      break;
    case DUP:
      i = dupInstruction();
      break;
    case SWAP:
      i = swapInstruction();
      break;
    case NUMOP:
      i = numOpInstruction();
      break;
    case LOAD:
      i = loadInstruction();
      break;
    case STORE:
      i = storeInstruction();
      break;
    case INC:
      i = incInstruction();
      break;
    case GOTO:
      i = gotoInstruction();
      break;
    case IF:
      i = ifInstruction();
      break;
    case LOOKUPSWITCH:
      i = lookupSwitchInstruction();
      break;
    case TABLESWITCH:
      i = tableSwitchInstruction();
      break;
    case NEW:
      i = newInstruction();
      break;
    case CHECKCAST:
      i = checkCastInstruction();
      break;
    case INSTANCEOF:
      i = instanceOfInstruction();
      break;
    case GETSTATIC:
      i = getStaticInstruction();
      break;
    case PUTSTATIC:
      i = putStaticInstruction();
      break;
    case GETFIELD:
      i = getFieldInstruction();
      break;
    case PUTFIELD:
      i = putFieldInstruction();
      break;
    case INVOKEDEFINITE:
      i = invokeDefiniteInstruction();
      break;
    case INVOKEVIRTUAL:
      i = invokeVirtualInstruction();
      break;
    case INVOKEINTERFACE:
      i = invokeInterfaceInstruction();
      break;
    case RETURN:
      i = returnInstruction();
      break;
    case ARRAYLENGTH:
      i = arrayLengthInstruction();
      break;
    case ARRAYLOAD:
      i = arrayLoadInstruction();
      break;
    case ARRAYSTORE:
      i = arrayStoreInstruction();
      break;
    case THROW:
      i = throwInstruction();
      break;
    case JSR:
      i = jsrInstruction();
      break;
    case RET:
      i = retInstruction();
      break;
    default:
      jj_la1[54] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    i.address = address.image;
    i.blockIndex = index;
    // todo: if/when addresses become optional, we'll have to use the instruction
    // name token instead: this means changing every instruction that appears
    // below
    i.token = address;
    if (addressMap.put(address.image, i) != null) {if (true) throw new ParseException("Duplicate definition of address " + address.image, address);}
    {if (true) return i;}
    throw new Error("Missing return statement in function");
  }

  final public NopInstruction nopInstruction() throws ParseException {
    jj_consume_token(NOP);
    {if (true) return new NopInstruction();}
    throw new Error("Missing return statement in function");
  }

  final public PushInstruction pushInstruction() throws ParseException {
  Value value;
  JCVMOperandType type;
    jj_consume_token(PUSH);
    type = operandType();
    value = constant(type);
    {if (true) return new PushInstruction(value);}
    throw new Error("Missing return statement in function");
  }

  final public PopInstruction popInstruction() throws ParseException {
  int words;
    jj_consume_token(POP);
    words = decimalNumeral();
    {if (true) return new PopInstruction(words);}
    throw new Error("Missing return statement in function");
  }

  final public DupInstruction dupInstruction() throws ParseException {
  Token t;
  int words, depth;
    t = jj_consume_token(DUP);
    words = decimalNumeral();
    depth = decimalNumeral();
    if (0 < depth && depth < words) {if (true) throw new ParseException("Depth must either be 0 or >= to number of words", t);}
    {if (true) return new DupInstruction(words, depth);}
    throw new Error("Missing return statement in function");
  }

  final public SwapInstruction swapInstruction() throws ParseException {
  int top, following;
    jj_consume_token(SWAP);
    top = decimalNumeral();
    following = decimalNumeral();
    {if (true) return new SwapInstruction(top, following);}
    throw new Error("Missing return statement in function");
  }

  final public NumOpInstruction numOpInstruction() throws ParseException {
  JCVMNumericType operandType, resultType = null;
  int operator;
    jj_consume_token(NUMOP);
    operandType = numericType();
    operator = numericOperator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case B:
    case S:
    case I:
      resultType = numericType();
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    {if (true) return new NumOpInstruction(operator, operandType, resultType == null ? operandType : resultType);}
    throw new Error("Missing return statement in function");
  }

  final public LoadInstruction loadInstruction() throws ParseException {
  JCVMOperandType type;
  int index;
    jj_consume_token(LOAD);
    type = wordOperandType();
    index = decimalNumeral();
    {if (true) return new LoadInstruction(type, index);}
    throw new Error("Missing return statement in function");
  }

  final public StoreInstruction storeInstruction() throws ParseException {
  JCVMOperandType type;
  int index;
    jj_consume_token(STORE);
    type = wordOperandType();
    index = decimalNumeral();
    {if (true) return new StoreInstruction(type, index);}
    throw new Error("Missing return statement in function");
  }

  final public IncInstruction incInstruction() throws ParseException {
  JCVMNumericType type;
  int index;
  NumericValue value;
    jj_consume_token(INC);
    type = wordNumericType();
    index = decimalNumeral();
    value = numericLiteral(type);
    {if (true) return new IncInstruction(type, index, value);}
    throw new Error("Missing return statement in function");
  }

  final public GotoInstruction gotoInstruction() throws ParseException {
  Token address;
    jj_consume_token(GOTO);
    address = address();
    {if (true) return new GotoInstruction(address);}
    throw new Error("Missing return statement in function");
  }

  final public IfInstruction ifInstruction() throws ParseException {
  int operator;
  JCVMOperandType type;
  Value value = null;
  Token address, t;
    // todo : operand type
      t = jj_consume_token(IF);
    type = operandType();
    operator = comparisonOperator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
    case DECIMAL_NUMERAL:
      value = nullComparison(type);
      break;
    default:
      jj_la1[56] = jj_gen;
      ;
    }
    jj_consume_token(GOTO);
    address = address();
    if ((type == JCVMReferenceType.TYPE) && (operator != JCVMOperandType.EQ) && (operator != JCVMOperandType.NE))
      {if (true) throw new ParseException("Only ne or eq is allowed in this context", t);}

    {if (true) return new IfInstruction(operator, type, value, address);}
    throw new Error("Missing return statement in function");
  }

  final public LookupSwitchInstruction lookupSwitchInstruction() throws ParseException {
  JCVMNumericType type;
  Map switches = new HashMap();
  Token address;
    jj_consume_token(LOOKUPSWITCH);
    type = wordNumericType();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL_NUMERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case LPAREN:
    case MINUS:
      matchTableEntry(switches, type);
      label_16:
      while (true) {
        if (jj_2_8(2)) {
          ;
        } else {
          break label_16;
        }
        jj_consume_token(COMMA);
        matchTableEntry(switches, type);
      }
      break;
    default:
      jj_la1[57] = jj_gen;
      ;
    }
    jj_consume_token(COMMA);
    jj_consume_token(_DEFAULT);
    jj_consume_token(RIGHTARROW);
    address = address();
    {if (true) return new LookupSwitchInstruction(type, switches, address);}
    throw new Error("Missing return statement in function");
  }

  final public void matchTableEntry(Map switches, JCVMNumericType type) throws ParseException {
  NumericValue value;
  Token address;
    value = numericLiteral(type);
    jj_consume_token(RIGHTARROW);
    address = address();
    switches.put(value, address);
  }

  final public TableSwitchInstruction tableSwitchInstruction() throws ParseException {
  JCVMNumericType type;
  int value;
  List addresses = new LinkedList();
  Token address;
    jj_consume_token(TABLESWITCH);
    type = wordNumericType();
    value = integerConstant();
    jj_consume_token(RIGHTARROW);
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECIMAL_NUMERAL:
        ;
        break;
      default:
        jj_la1[58] = jj_gen;
        break label_17;
      }
      address = address();
                                                         addresses.add(address);
    }
    jj_consume_token(COMMA);
    jj_consume_token(_DEFAULT);
    jj_consume_token(RIGHTARROW);
    address = address();
    {if (true) return new TableSwitchInstruction(type, value, addresses, address);}
    throw new Error("Missing return statement in function");
  }

  final public NewInstruction newInstruction() throws ParseException {
  ReferenceType type;
    jj_consume_token(NEW);
    if (jj_2_9(2147483647)) {
      type = arrayType();
                                                  {if (true) return new NewArrayInstruction((ArrayType) type);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOP:
      case PUSH:
      case POP:
      case DUP:
      case SWAP:
      case NUMOP:
      case LOAD:
      case STORE:
      case INC:
      case LOOKUPSWITCH:
      case TABLESWITCH:
      case CHECKCAST:
      case GETSTATIC:
      case PUTSTATIC:
      case GETFIELD:
      case PUTFIELD:
      case INVOKEDEFINITE:
      case INVOKEINTERFACE:
      case INVOKEVIRTUAL:
      case ARRAYLENGTH:
      case ARRAYLOAD:
      case ARRAYSTORE:
      case JSR:
      case RET:
      case R:
      case B:
      case S:
      case I:
      case GT:
      case LT:
      case EQ:
      case LE:
      case GE:
      case NE:
      case NEG:
      case ADD:
      case SUB:
      case MUL:
      case DIV:
      case REM:
      case AND:
      case OR:
      case XOR:
      case SHL:
      case SHR:
      case USHR:
      case TO:
      case CMP:
      case IDENTIFIER:
        type = classReference();
                              {if (true) return new NewClassInstruction((ClassReference) type);}
        break;
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public CheckCastInstruction checkCastInstruction() throws ParseException {
  ReferenceType type;
    jj_consume_token(CHECKCAST);
    type = referenceType();
    {if (true) return new CheckCastInstruction(type);}
    throw new Error("Missing return statement in function");
  }

  final public InstanceOfInstruction instanceOfInstruction() throws ParseException {
  ReferenceType type;
    jj_consume_token(INSTANCEOF);
    type = referenceType();
    {if (true) return new InstanceOfInstruction(type);}
    throw new Error("Missing return statement in function");
  }

  final public GetStaticInstruction getStaticInstruction() throws ParseException {
  FieldReference field;
    jj_consume_token(GETSTATIC);
    field = fieldName();
    {if (true) return new GetStaticInstruction(field);}
    throw new Error("Missing return statement in function");
  }

  final public PutStaticInstruction putStaticInstruction() throws ParseException {
  FieldReference field;
    jj_consume_token(PUTSTATIC);
    field = fieldName();
    {if (true) return new PutStaticInstruction(field);}
    throw new Error("Missing return statement in function");
  }

  final public GetFieldInstruction getFieldInstruction() throws ParseException {
  boolean thisField = false;
  FieldReference field;
    jj_consume_token(GETFIELD);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THIS:
      jj_consume_token(THIS);
                        thisField = true;
      break;
    default:
      jj_la1[60] = jj_gen;
      ;
    }
    field = fieldName();
    {if (true) return new GetFieldInstruction(field, thisField);}
    throw new Error("Missing return statement in function");
  }

  final public PutFieldInstruction putFieldInstruction() throws ParseException {
  boolean thisField = false;
  FieldReference field;
    jj_consume_token(PUTFIELD);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THIS:
      jj_consume_token(THIS);
                        thisField = true;
      break;
    default:
      jj_la1[61] = jj_gen;
      ;
    }
    field = fieldName();
    {if (true) return new PutFieldInstruction(field, thisField);}
    throw new Error("Missing return statement in function");
  }

  final public InvokeDefiniteInstruction invokeDefiniteInstruction() throws ParseException {
  MethodReference methodReference;
  ConstructorReference constructorReference;
    jj_consume_token(INVOKEDEFINITE);
    if (jj_2_10(2147483647)) {
      constructorReference = constructorReference();
                                                                                                 {if (true) return new InvokeConstructorInstruction(constructorReference);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOP:
      case PUSH:
      case POP:
      case DUP:
      case SWAP:
      case NUMOP:
      case LOAD:
      case STORE:
      case INC:
      case LOOKUPSWITCH:
      case TABLESWITCH:
      case CHECKCAST:
      case GETSTATIC:
      case PUTSTATIC:
      case GETFIELD:
      case PUTFIELD:
      case INVOKEDEFINITE:
      case INVOKEINTERFACE:
      case INVOKEVIRTUAL:
      case ARRAYLENGTH:
      case ARRAYLOAD:
      case ARRAYSTORE:
      case JSR:
      case RET:
      case R:
      case B:
      case S:
      case I:
      case GT:
      case LT:
      case EQ:
      case LE:
      case GE:
      case NE:
      case NEG:
      case ADD:
      case SUB:
      case MUL:
      case DIV:
      case REM:
      case AND:
      case OR:
      case XOR:
      case SHL:
      case SHR:
      case USHR:
      case TO:
      case CMP:
      case IDENTIFIER:
        methodReference = methodReference();
                                          {if (true) return new InvokeDefiniteMethodInstruction(methodReference);}
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public InvokeVirtualInstruction invokeVirtualInstruction() throws ParseException {
  MethodReference method;
    jj_consume_token(INVOKEVIRTUAL);
    method = methodReference();
    {if (true) return new InvokeVirtualInstruction(method);}
    throw new Error("Missing return statement in function");
  }

  final public InvokeInterfaceInstruction invokeInterfaceInstruction() throws ParseException {
  MethodReference method;
    jj_consume_token(INVOKEINTERFACE);
    method = methodReference();
    {if (true) return new InvokeInterfaceInstruction(method);}
    throw new Error("Missing return statement in function");
  }

  final public ReturnInstruction returnInstruction() throws ParseException {
  JCVMOperandType type = null;
    jj_consume_token(RETURN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R:
    case B:
    case S:
    case I:
      type = operandType();
      break;
    default:
      jj_la1[63] = jj_gen;
      ;
    }
    {if (true) return new ReturnInstruction(type);}
    throw new Error("Missing return statement in function");
  }

  final public ArrayLengthInstruction arrayLengthInstruction() throws ParseException {
    jj_consume_token(ARRAYLENGTH);
    {if (true) return new ArrayLengthInstruction();}
    throw new Error("Missing return statement in function");
  }

  final public ArrayLoadInstruction arrayLoadInstruction() throws ParseException {
  JCVMOperandType type;
    jj_consume_token(ARRAYLOAD);
    type = operandType();
    {if (true) return new ArrayLoadInstruction(type);}
    throw new Error("Missing return statement in function");
  }

  final public ArrayStoreInstruction arrayStoreInstruction() throws ParseException {
  JCVMOperandType type;
    jj_consume_token(ARRAYSTORE);
    type = operandType();
    {if (true) return new ArrayStoreInstruction(type);}
    throw new Error("Missing return statement in function");
  }

  final public ThrowInstruction throwInstruction() throws ParseException {
    jj_consume_token(THROW);
    {if (true) return new ThrowInstruction();}
    throw new Error("Missing return statement in function");
  }

  final public JsrInstruction jsrInstruction() throws ParseException {
  Token address;
    jj_consume_token(JSR);
    address = address();
    {if (true) return new JsrInstruction(address);}
    throw new Error("Missing return statement in function");
  }

  final public RetInstruction retInstruction() throws ParseException {
  int index;
    jj_consume_token(RET);
    index = decimalNumeral();
    {if (true) return new RetInstruction(index);}
    throw new Error("Missing return statement in function");
  }

  final public Value constant(JCVMOperandType type) throws ParseException {
  Value v;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NULL:
      v = nullLiteral(type);
      break;
    case DECIMAL_NUMERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case LPAREN:
    case MINUS:
      v = numericLiteral(type);
      break;
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return v;}
    throw new Error("Missing return statement in function");
  }

  final public Value nullComparison(JCVMOperandType type) throws ParseException {
  NullValue v;
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL_NUMERAL:
      t = jj_consume_token(DECIMAL_NUMERAL);
    if (!"0".equals(t.image)) {if (true) throw new ParseException("Encountered \"" + t.image + "\" was expecting \"0\" or \"null\"", t);}

    try {
       {if (true) return ((JCVMNumericType) type).createValue(0);}
    }
    catch (ClassCastException e) {
       {if (true) throw new ParseException("0 not a valid argument in this context", t);}
    }
      break;
    case NULL:
      v = nullLiteral(type);
                            {if (true) return v;}
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public JCVMOperandType operandType() throws ParseException {
  JCVMNumericType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case B:
    case S:
    case I:
      type = numericType();
                           {if (true) return type;}
      break;
    case R:
      jj_consume_token(R);
          {if (true) return JCVMReferenceType.TYPE;}
      break;
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public JCVMOperandType wordOperandType() throws ParseException {
  JCVMOperandType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S:
    case I:
      type = wordNumericType();
                               {if (true) return type;}
      break;
    case R:
      jj_consume_token(R);
          {if (true) return JCVMReferenceType.TYPE;}
      break;
    default:
      jj_la1[67] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public JCVMNumericType numericType() throws ParseException {
  JCVMNumericType type;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case S:
    case I:
      type = wordNumericType();
                               {if (true) return type;}
      break;
    case B:
      jj_consume_token(B);
          {if (true) return JCVMByteType.TYPE;}
      break;
    default:
      jj_la1[68] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public JCVMNumericType wordNumericType() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case I:
      jj_consume_token(I);
          {if (true) return JCVMIntType.TYPE;}
      break;
    case S:
      jj_consume_token(S);
          {if (true) return JCVMShortType.TYPE;}
      break;
    default:
      jj_la1[69] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int numericOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEG:
      jj_consume_token(NEG);
             {if (true) return JCVMNumericType.NEG;}
      break;
    case ADD:
      jj_consume_token(ADD);
             {if (true) return JCVMNumericType.ADD;}
      break;
    case SUB:
      jj_consume_token(SUB);
             {if (true) return JCVMNumericType.SUB;}
      break;
    case MUL:
      jj_consume_token(MUL);
             {if (true) return JCVMNumericType.MUL;}
      break;
    case DIV:
      jj_consume_token(DIV);
             {if (true) return JCVMNumericType.DIV;}
      break;
    case REM:
      jj_consume_token(REM);
             {if (true) return JCVMNumericType.REM;}
      break;
    case AND:
      jj_consume_token(AND);
             {if (true) return JCVMNumericType.AND;}
      break;
    case OR:
      jj_consume_token(OR);
             {if (true) return JCVMNumericType.OR;}
      break;
    case XOR:
      jj_consume_token(XOR);
             {if (true) return JCVMNumericType.XOR;}
      break;
    case SHL:
      jj_consume_token(SHL);
             {if (true) return JCVMNumericType.SHL;}
      break;
    case SHR:
      jj_consume_token(SHR);
             {if (true) return JCVMNumericType.SHR;}
      break;
    case USHR:
      jj_consume_token(USHR);
             {if (true) return JCVMNumericType.USHR;}
      break;
    case TO:
      jj_consume_token(TO);
             {if (true) return JCVMNumericType.TO;}
      break;
    case TOB:
      jj_consume_token(TOB);
             {if (true) return JCVMNumericType.TOB;}
      break;
    case CMP:
      jj_consume_token(CMP);
             {if (true) return JCVMNumericType.CMP;}
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int comparisonOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case EQ:
      jj_consume_token(EQ);
           {if (true) return JCVMOperandType.EQ;}
      break;
    case NE:
      jj_consume_token(NE);
           {if (true) return JCVMOperandType.NE;}
      break;
    case GT:
      jj_consume_token(GT);
           {if (true) return JCVMNumericType.GT;}
      break;
    case LT:
      jj_consume_token(LT);
           {if (true) return JCVMNumericType.LT;}
      break;
    case LE:
      jj_consume_token(LE);
           {if (true) return JCVMNumericType.LE;}
      break;
    case GE:
      jj_consume_token(GE);
           {if (true) return JCVMNumericType.GE;}
      break;
    default:
      jj_la1[71] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_3R_98() {
    if (jj_scan_token(HEX_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(DECIMAL_NUMERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_3R_102()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_83() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_95()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_96()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    if (jj_3R_99()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_100() {
    if (jj_3R_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(STATIC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_3R_101()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) {
    jj_scanpos = xsp;
    if (jj_3R_81()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_18()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(FINAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_scan_token(LBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_93() {
    if (jj_3R_84()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_103()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_6()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_3R_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(VOID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(INIT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(VOID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_scan_token(ABSTRACT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_18()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_3R_82()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_18()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_3R_83()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_88() {
    if (jj_scan_token(PRIVATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_3R_102()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(INIT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_87() {
    if (jj_scan_token(PROTECTED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_86() {
    if (jj_scan_token(PUBLIC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_3R_89()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(DECIMAL_NUMERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_18() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_28()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_79() {
    if (jj_scan_token(CMP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_78() {
    if (jj_scan_token(TO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(USHR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(SHR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_scan_token(SHL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(XOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_scan_token(REM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_scan_token(DIV)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(MUL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(SUB)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    if (jj_scan_token(ADD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(NEG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_scan_token(NE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() {
    if (jj_scan_token(GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_scan_token(LE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_scan_token(EQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(LT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(GT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_scan_token(I)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(B)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(R)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_scan_token(RET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(JSR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(ARRAYSTORE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(ARRAYLOAD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(ARRAYLENGTH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(INVOKEVIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(INVOKEINTERFACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(INVOKEDEFINITE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(PUTFIELD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(GETFIELD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(PUTSTATIC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(GETSTATIC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(CHECKCAST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(TABLESWITCH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(LOOKUPSWITCH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(INC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(STORE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(LOAD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(NUMOP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(SWAP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(DUP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(POP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(PUSH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(NOP)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) {
    jj_scanpos = xsp;
    if (jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) {
    jj_scanpos = xsp;
    if (jj_3R_61()) {
    jj_scanpos = xsp;
    if (jj_3R_62()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) {
    jj_scanpos = xsp;
    if (jj_3R_64()) {
    jj_scanpos = xsp;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) {
    jj_scanpos = xsp;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) {
    jj_scanpos = xsp;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) {
    jj_scanpos = xsp;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3R_76()) {
    jj_scanpos = xsp;
    if (jj_3R_77()) {
    jj_scanpos = xsp;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3R_79()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_18()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(CLASS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_105() {
    if (jj_scan_token(FALSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_scan_token(TRUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_scan_token(INT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_112() {
    if (jj_scan_token(SHORT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_111() {
    if (jj_scan_token(BYTE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_110() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) {
    jj_scanpos = xsp;
    if (jj_3R_112()) {
    jj_scanpos = xsp;
    if (jj_3R_113()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_109() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_scan_token(BOOLEAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_106() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_108()) {
    jj_scanpos = xsp;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_101() {
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_92() {
    if (jj_scan_token(NATIVE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_scan_token(OCTAL_LITERAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public ParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[72];
  final private int[] jj_la1_0 = {0x2000000,0x0,0x0,0x5d892000,0x5d882000,0x0,0x200000,0x0,0x5d082000,0x5d082000,0x20000,0x100000,0x7d48e000,0x7d48e000,0x20000,0x7d48e000,0x7d48e000,0x0,0x0,0x0,0x40000,0x40000,0x0,0x0,0x0,0x0,0x0,0x2048c000,0x80000,0x0,0x0,0x0,0x0,0x2040c000,0x0,0x2040c000,0x0,0x2040c000,0x2040c000,0x20408000,0x0,0x0,0x2040c000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private int[] jj_la1_1 = {0x0,0x77a6ff80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x77a6ff84,0x77a6ff80,0x0,0x77a6ff84,0x77a6ff80,0x0,0x0,0x0,0x22,0x2,0x0,0x0,0x1,0x0,0x0,0x77a6ff80,0x0,0x0,0x77a6ff80,0x77a6ff84,0x1,0x77a6ff84,0x0,0x77a6ff80,0x0,0x77a6ff80,0x0,0x0,0x77a6ff80,0x0,0x77a6ff80,0x77a6ff80,0x77a6ff80,0x0,0x2,0x0,0x0,0x0,0x2,0x0,0x0,0x77a6ff80,0xf7f7ff90,0x0,0x20,0x0,0x0,0x77a6ff80,0x8000000,0x8000000,0x77a6ff80,0x0,0x20,0x20,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private int[] jj_la1_2 = {0x0,0x5ffffff7,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x5ffffff7,0x5ffffff7,0x0,0x5ffffff7,0x5ffffff7,0x0,0x0,0x0,0x80000000,0x80000000,0x0,0x0,0x0,0x0,0x0,0x5ffffff7,0x0,0x0,0x5ffffff7,0x5ffffff7,0x0,0x5ffffff7,0x0,0x5ffffff7,0x0,0x5ffffff7,0x0,0x0,0x5ffffff7,0x0,0x5ffffff7,0x5ffffff7,0x5ffffff7,0x0,0x80000000,0x0,0x0,0x80000000,0x0,0x0,0x80000000,0x5ffffff7,0x3f,0x380,0x80000000,0x80000000,0x80000000,0x5ffffff7,0x0,0x0,0x5ffffff7,0x3c0,0x80000000,0x80000000,0x3c0,0x340,0x380,0x300,0x7fff0000,0xfc00,};
  final private int[] jj_la1_3 = {0x0,0x4,0x100,0x20,0x20,0x1000,0x0,0x2000,0x0,0x0,0x0,0x0,0x4,0x4,0x0,0x4,0x4,0x1000,0x400,0x40000,0x10143,0x10043,0x1000,0x400,0x0,0x120,0x1000,0x4,0x0,0x400,0x4,0x4,0x0,0x4,0x400,0x4,0x400,0x4,0x0,0x0,0x4,0x1000,0x4,0x4,0x4,0x1000,0x10043,0x40,0x10000,0x3,0x0,0x10000,0x0,0x20004,0x0,0x0,0x0,0x10043,0x0,0x4,0x0,0x0,0x4,0x0,0x10043,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public Parser(java.io.InputStream stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 72; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[115];
    for (int i = 0; i < 115; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 72; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 115; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
