/* Generated By:JavaCC: Do not edit this line. ParseException.java Version 2.1 */
package carmel.parser;

/**
 * This exception is thrown when parse errors are encountered.
 * You can explicitly create objects of this exception type by
 * calling the method generateParseException in the generated
 * parser.
 *
 * You can modify this class to customize your error reporting
 * mechanisms so long as you retain the public fields.
 */
public class ParseException extends LexOrParseException {

    /**
    * This constructor is used by the method "generateParseException"
    * in the generated parser.  Calling this constructor generates
    * a new object of this type with the fields "currentToken",
    * "expectedTokenSequences", and "tokenImage" set.  The boolean
    * flag "specialConstructor" is also set to true to indicate that
    * this constructor was used to create this object.
    * This constructor calls its super class with the empty string
    * to force the "toString" method of parent class "Throwable" to
    * print the error message in the form:
    *     ParseException: <result of getMessage>
    */
    public ParseException(Token token, int[][] expectedTokens, String[] tokenImage) {
        super(createErrorMessage(token.next, expectedTokens, tokenImage), token.next.beginLine, token.next.beginColumn);
    }

    protected static String createErrorMessage(Token token, int[][] expectedTokens, String[] tokenImage) {
        // hack:
        // we know that <IDENTIFIER> is preceded by 48 alternate productions
        // displaying these to the user is bound to confuse, so they're removed
        int index = expectedTokens.length;

        while (--index >= 0) {
            if (expectedTokens[index][0] == ParserConstants.IDENTIFIER) break;
        }

        if (index != -1) {
            int[][] newSequence = new int[expectedTokens.length - 48][];

            System.arraycopy(expectedTokens, 0,     newSequence, 0,             index - 48);
            System.arraycopy(expectedTokens, index, newSequence, index - 48,    newSequence.length - (index - 48));

            expectedTokens = newSequence;
        }

        StringBuffer expected = new StringBuffer("Was expecting");

        if (expectedTokens.length != 1) expected.append(" one of");

        expected.append(':');

        int maxSize = 0;

        for (int i = 0; i < expectedTokens.length; i++) {
            expected.append(eol).append('\t');

            if (maxSize < expectedTokens[i].length) {
                maxSize = expectedTokens[i].length;
            }
            for (int j = 0; j < expectedTokens[i].length; j++) {
                expected.append(tokenImage[expectedTokens[i][j]]).append(' ');
            }
            if (expectedTokens[i][expectedTokens[i].length - 1] != 0) {
                expected.append("...");
            }
        }

        StringBuffer message = new StringBuffer("Encountered \"");

        for (int i = 0; i < maxSize; i++) {
            if (i != 0) message.append(' ');

            if (token.kind == 0) {
                message.append(tokenImage[0]);
                break;
            }

            message.append(add_escapes(token.image));
            token = token.next;
        }

        return message.append('"').append(eol).append(expected).toString();
    }

    /**
    * The following constructors are for use by you for whatever
    * purpose you can think of.  Constructing the exception in this
    * manner makes the exception behave in the normal way - i.e., as
    * documented in the class "Throwable".  The fields "errorToken",
    * "expectedTokenSequences", and "tokenImage" do not contain
    * relevant information.  The JavaCC generated code does not use
    * these constructors.
    *
    * BUG:  In fact JavaCC DOES use the following constructor in case of
    *       an internal error.
    */

    public ParseException() {
        super(null, -1, -1);
        throw new Error();
    }

    public ParseException(String message, Token token) {
        super(message, token.beginLine, token.beginColumn);
    }

    /**
    * The end of line string for this machine.
    */
    protected static final String eol = System.getProperty("line.separator", "\n");

    /**
    * Used to convert raw characters to their escaped version
    * when these raw version cannot be used as part of an ASCII
    * string literal.
    */
    protected static String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();

        for (int i = 0; i < str.length(); i++) {
            char ch = str.charAt(i);
            switch (ch) {
                case 0 : continue;
                case '\b':
                    retval.append("\\b");
                    continue;
                case '\t':
                    retval.append("\\t");
                    continue;
                case '\n':
                    retval.append("\\n");
                    continue;
                case '\f':
                    retval.append("\\f");
                    continue;
                case '\r':
                    retval.append("\\r");
                    continue;
                case '\"':
                    retval.append("\\\"");
                    continue;
                case '\'':
                    retval.append("\\\'");
                    continue;
                case '\\':
                    retval.append("\\\\");
                    continue;
                default:
                    if (ch < 0x20 || ch > 0x7e) {
                        StringBuffer s = new StringBuffer(8).append("0000").append(Integer.toString(ch, 16));
                        retval.append("\\u").append(s.substring(s.length() - 4));
                    }
                    else
                       retval.append(ch);
                    continue;
            }
        }

        return retval.toString();
   }
}
