package carmel.parser;

import carmel.interpreter.CarmelSource;

public class LexOrParseException extends Exception {

    protected String errorMessage;
    protected CarmelSource source;
    protected int line;
    protected int column;

    public LexOrParseException(String errorMessage, int line, int column) {
        this.errorMessage = errorMessage;
        this.line = line;
        this.column = column;
    }

    public LexOrParseException(String errorMessage, CarmelSource source, int line, int column) {
        this(errorMessage, line, column);
        this.source = source;
    }

    // this is just in case it is printed to screen
    public String getMessage() {
        return (source == null ? "unknown source" : source.getName()) + ": " + errorMessage + " at line " + line + ", column " + column;
    }

    public String getErrorMessage() { return errorMessage; }

    public CarmelSource getSource() { return source; }

    public void setSource(CarmelSource source) {
        this.source = source;
    }

    public int getLine() { return line; }
    public int getColumn() { return column; }
}