package carmel.interpreter;

public class VMException extends Exception {
    protected Throwable cause;

    public VMException(Throwable cause) {
        // 1.3 code
        super();
        this.cause = cause;

        // 1.4 code
        // super(cause);
    }

    public VMException(String message, Throwable cause) {
        // 1.3 code
        super(message);
        this.cause = cause;

        // 1.4 code
        // super(message, cause);
    }

    // for compatibility with JDK 1.3, not needed for 1.4
    public Throwable getCause() { return cause; }

    public String getMessage() {
        return cause == null ? super.getMessage() : super.getMessage() + ": " + cause.getMessage();
    }
}