package carmel.interpreter;

import java.io.*;
import java.net.*;

public class URLCarmelSource extends CarmelSource {

    protected URL url;

    public URLCarmelSource(URL url) throws IOException {
        super(url.getFile().substring(url.getFile().lastIndexOf('/') + 1), url.openConnection().getContentLength());
        this.url = url;
    }

    public Reader openReader() throws IOException {
        return new InputStreamReader(url.openStream());
    }

    public static CarmelSource createCarmelSource(URL url) throws IOException {
        if ("file".equals(url.getProtocol())) {
            try {
                return new FileCarmelSource(new File(removeURLEscapes(url.getFile())));
            }
            catch (FileNotFoundException e) {}
        }

        return new URLCarmelSource(url);
    }

    public static String removeURLEscapes(String file) {
        char[] oldChars = file.toCharArray();
        int oldLength = oldChars.length;
        char[] newChars = new char[oldLength];

        int startIndex = 0, index = 0, newLength = 0;

        for(;;) {
            index = file.indexOf('%', startIndex);

            if (index == -1) index = oldLength;
            int count = index - startIndex;

            System.arraycopy(oldChars, startIndex, newChars, newLength, count);

            newLength += count;

            if (index == oldLength) break;

            try {
                try {
                    newChars[newLength] = (char) Short.parseShort(file.substring(index + 1, index + 3), 16);
                    newLength++;
                }
                catch (NumberFormatException e) {
                    System.arraycopy(oldChars, index, newChars, newLength, 3);
                    newLength += 3;
                }
            }
            catch (IndexOutOfBoundsException e) {
                count = oldLength - index;
                System.arraycopy(oldChars, index, newChars, newLength, count);
                newLength += count;
                break;
            }

            startIndex = index + 3;
        }

        return new String(newChars, 0, newLength);
    }
}