package carmel.interpreter;

import java.io.*;

public class StringCarmelSource extends CarmelSource {

    protected String string;

    public StringCarmelSource(String name, String string) {
        super(name, string.length());
        this.string = string;
    }

    public Reader openReader() throws IOException {
        return new StringReader(string);
    }

    // overriden for performance reasons
    public String getContents() throws IOException {
        return string;
    }
}