package carmel.interpreter;

import java.io.*;

public class FileCarmelSource extends CarmelSource {

    protected File file;

    public FileCarmelSource(File file) throws FileNotFoundException {
        super(file.getName());
        if (!file.exists()) throw new FileNotFoundException(file.getAbsolutePath() + " not found");
        this.file = file;
    }

    public boolean isReadOnly() { return false; }
    public int getLength() { return (int) file.length(); }

    public Reader openReader() throws IOException {
        try {
            return new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Writer openWriter() throws IOException {
        try {
            return new FileWriter(file);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }
}