package carmel.interpreter;

import java.io.*;
import java.net.*;

public abstract class CarmelSource {

    protected String name;
    protected int length;

    public CarmelSource(String name) {
        this.name = name;
    }

    public CarmelSource(String name, int length) {
        this(name);
        this.length = length;
    }

    public String getName() { return name; }
    public int getLength() { return length; }
    public boolean isReadOnly() { return true; }

    public abstract Reader openReader() throws IOException;

    public Writer openWriter() throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException("Source is read only");
    }

    public String getContents() throws IOException {
        char[] contents = new char[getLength()];
        Reader reader = openReader();
        reader.read(contents);
        reader.close();
        return new String(contents);
    }

    public void setContents(String string) throws UnsupportedOperationException, IOException {
        Writer writer = openWriter();
        writer.write(string);
        writer.close();
    }
}