package carmel.interpreter;

import carmel.value.ClassValue;
import java.util.*;

public class CarmelException extends Exception {

    protected ClassValue exception;

    protected LinkedList stackTrace = new LinkedList();
    protected CallStack callStack = null;

    public CarmelException(ClassValue exception) {
        this.exception = exception;
    }

    public ClassValue getException() { return exception; }

    protected void addFrame(StackFrame frame) {
        stackTrace.add(frame);
    }

    public CallStack getCallStack() {
        return callStack == null ? callStack = new CallStack(stackTrace) : callStack;
    }

    public void printCarmelStackTrace() {
        printCarmelStackTrace(System.err);
    }

    public void printCarmelStackTrace(java.io.PrintStream s) {
        String message = getMessage();

        s.print(exception.getType().getName());

        if (message != null) {
            s.print(": ");
            s.print(message);
        }

        s.println();

        for (Iterator i = stackTrace.iterator(); i.hasNext();) {
            StackFrame frame = (StackFrame) i.next();

            s.print("\tat ");
            s.print(frame.getMethod().getName());
            s.print('(');
            s.print(frame.getCarmelSource().getName());
            s.print(':');
            s.print(frame.getPC().getLineNumber());
            s.println(')');
        }
    }
}