package carmel.interpreter;

import javax.swing.event.EventListenerList;
import java.util.*;

public class CallStack {

    protected LinkedList list;
    protected EventListenerList listeners = new EventListenerList();

    public CallStack() {
        this(new LinkedList());
    }

    protected CallStack(LinkedList frames) {
        list = frames;
    }

    public void push(StackFrame f) {
        list.addFirst(f);
        fireFramePushed(f);
    }

    public StackFrame pop() {
        StackFrame frame = (StackFrame) list.removeFirst();
        fireFramePopped(frame);
        return frame;
    }

    public StackFrame peek() {
        return (StackFrame) list.getFirst();
    }

    public boolean isEmpty() {
        return list.isEmpty();
    }

    public void setStack(CallStack stack) {
        clear();

        LinkedList newList = (LinkedList) stack.list.clone();

        while (!newList.isEmpty())
            push((StackFrame) newList.removeLast());
    }

    public void clear() {
        while (!isEmpty()) pop();
    }

    public int getDepth() {
        return list.size();
    }

    public StackFrame getFrame(int depth) {
        return (StackFrame) list.get(depth);
    }

    public void addCallStackListener(CallStackListener l) {
        listeners.add(CallStackListener.class, l);
    }

    public void removeCallStackListener(CallStackListener l) {
        listeners.remove(CallStackListener.class, l);
    }

    protected void fireFramePushed(StackFrame frame) {
        CallStackEvent e = new CallStackEvent(this, frame);
        Object[] list = listeners.getListenerList();

        for (int i = list.length - 2; i >= 0; i -= 2)
            if (list[i] == CallStackListener.class)
                ((CallStackListener) list[i + 1]).framePushed(e);
    }

    protected void fireFramePopped(StackFrame frame) {
        CallStackEvent e = new CallStackEvent(this, frame);
        Object[] list = listeners.getListenerList();

        for (int i = list.length - 2; i >= 0; i -= 2)
            if (list[i] == CallStackListener.class)
                ((CallStackListener) list[i + 1]).framePopped(e);
    }
}