package carmel.gui;

import carmel.interpreter.*;
import carmel.value.BottomValue;
import carmel.value.StackEntry;
import javax.swing.table.AbstractTableModel;

public abstract class StackEntryListTableModel extends AbstractTableModel implements StackEntryListListener, PrototypeValueTableModel {

    protected StackEntryList list;
    protected final String[] columnNames;
    protected static final Class[] columnClasses = new Class[] { Integer.class, StackEntry.class, String.class };
    protected final Object[] prototypeValues;

    public StackEntryListTableModel(String firstColumnName, Object firstColumnPrototypeValue) {
        columnNames = new String[] { firstColumnName, "Value", "Type" };
        prototypeValues = new Object[] { firstColumnPrototypeValue, BottomValue.BOTTOM, "undef" };
    }

    public StackEntryListTableModel(StackEntryList list, String firstColumnName, Object firstColumnPrototypeValue) {
        this(firstColumnName, firstColumnPrototypeValue);
        setStackEntryList(list);
    }

    public StackEntryList getStackEntryList() { return list; }

    public void setStackEntryList(StackEntryList list) {
        if (this.list != null) this.list.removeStackEntryListListener(this);
        this.list = list;
        if (list != null) list.addStackEntryListListener(this);
        fireTableDataChanged();
    }

    public int getRowCount() { return list == null ? 0 : list.getEntryListSize(); }

    public int getColumnCount() { return 3; }

    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) return new Integer(rowIndex);

        StackEntry entry;

        try {
            entry = list.getEntryNoVerification(rowIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return "invalid";
        }

        if (entry == null) return "none";

        switch (columnIndex) {
            case 1: return entry.toString();
            case 2: return entry.getJCVMType().getName();
            default: throw new IndexOutOfBoundsException();
        }
    }

    public Object getPrototypeValue(int column) {
        return prototypeValues[column];
    }
}