package carmel.gui;

import carmel.parser.LexOrParseException;
import carmel.interpreter.CarmelSource;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.*;
import javax.swing.text.BadLocationException;
import javax.swing.border.*;

public class SourceErrorDialog extends JDialog {

    protected Action saveAction, cancelAction;

    // JBuilder generated UI components
    JPanel contentPanel = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JButton cancelButton = new JButton();
    JButton okButton = new JButton();
    JSplitPane jSplitPane1 = new JSplitPane();
    JScrollPane errorMessageScrollPane = new JScrollPane();
    JTextArea errorMessageTextArea = new JTextArea();
    CarmelSourcePanel carmelSourcePanel = new CarmelSourcePanel();

    public SourceErrorDialog(Frame frame, LexOrParseException exception, String title) {
        super(frame, title, true);

        try {
            jbInit();
            pack();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }

        CarmelSource source = exception.getSource();

        cancelAction = new AbstractAction() {
            public void actionPerformed(ActionEvent event) {
                hide();
                dispose();
            }
        };

        if (source.isReadOnly()) {
            cancelAction.putValue(Action.NAME, "OK");
            okButton.setAction(cancelAction);
        }
        else {
            saveAction = new AbstractAction("OK") {
                public void actionPerformed(ActionEvent event) {
                    try {
                        carmelSourcePanel.save();
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, "Error saving changes: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
                    }

                    hide();
                    dispose();
                }
            };

            okButton.setAction(saveAction);

            cancelAction.putValue(Action.NAME, "Cancel");
            cancelButton.setAction(cancelAction);

            buttonPanel.add(cancelButton);
        }

        errorMessageTextArea.setText(exception.getErrorMessage());

        carmelSourcePanel.setCarmelSource(source);
        try {
            carmelSourcePanel.highlightLine(exception.getLine() - 1);
            carmelSourcePanel.setCaretPosition(exception.getLine() - 1, exception.getColumn() - 1);
        }
        catch (BadLocationException e) {}

        pack();

        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = getSize();

        if (frameSize.height > screenSize.height) frameSize.height = screenSize.height;
        if (frameSize.width > screenSize.width) frameSize.width = screenSize.width;

        setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    private void jbInit() throws Exception {
        contentPanel.setLayout(borderLayout1);
        jSplitPane1.setOrientation(JSplitPane.VERTICAL_SPLIT);
        errorMessageTextArea.setEditable(false);
        errorMessageTextArea.setColumns(80);
        errorMessageTextArea.setLineWrap(true);
        errorMessageTextArea.setRows(4);
        errorMessageTextArea.setWrapStyleWord(true);
        carmelSourcePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(165, 163, 151)),"Source Editor"));
        carmelSourcePanel.setRows(20);
        carmelSourcePanel.setColumns(80);
        errorMessageScrollPane.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.RAISED,Color.white,new Color(165, 163, 151)),"Error Message"));
        getContentPane().add(contentPanel, BorderLayout.CENTER);
        contentPanel.add(buttonPanel,  BorderLayout.SOUTH);
        buttonPanel.add(okButton, null);
        contentPanel.add(jSplitPane1,  BorderLayout.CENTER);
        jSplitPane1.add(carmelSourcePanel, JSplitPane.TOP);
        jSplitPane1.add(errorMessageScrollPane, JSplitPane.BOTTOM);
        errorMessageScrollPane.getViewport().add(errorMessageTextArea, null);
    }
}