package carmel.gui;

import carmel.interpreter.*;
import carmel.value.StackEntry;
import javax.swing.table.AbstractTableModel;

public class OperandStackTableModel extends AbstractTableModel implements OperandStackListener, PrototypeValueTableModel {

    protected OperandStack stack;
    protected static final String[] columnNames = new String[] { "Value",            "Type" };
    protected static final Class[] columnClasses = new Class[] { StackEntry.class,  String.class };
    protected static final Object[] prototypeValues = new Object[] { "undef", "undef" };

    public OperandStackTableModel() {}

    public OperandStackTableModel(OperandStack stack) {
        setOperandStack(stack);
    }

    public OperandStack getOperandStack() { return stack; }

    public void setOperandStack(OperandStack stack) {
        if (this.stack != null) this.stack.removeStackEntryListListener(this);
        this.stack = stack;
        if (stack != null) stack.addStackEntryListListener(this);
        fireTableDataChanged();
    }

    public int getRowCount() { return stack == null ? 0 : stack.getEntryListSize(); }

    public int getColumnCount() { return 2; }

    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        StackEntry entry;

        try {
            entry = stack.getEntryNoVerification(rowIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return "invalid";
        }

        if (entry == null) return "undef";

        switch (columnIndex) {
            case 0: return entry.toString();
            case 1: return entry.getJCVMType().getName();
            default: throw new IndexOutOfBoundsException();
        }
    }

    public void entriesPopped(OperandStackEvent e) {
        // remove the popped entries
        fireTableRowsDeleted(0, e.getNumWords() - 1);
    }

    public void entriesPushed(OperandStackEvent e) {
        // add the popped entries
        fireTableRowsInserted(0, e.getNumWords() - 1);
    }

    public void entriesChanged(OperandStackEvent e) {
        // update the relevant rows
        fireTableRowsUpdated(0, e.getNumWords());
    }

    public Object getPrototypeValue(int column) {
        return prototypeValues[column];
    }
}