package carmel.gui;

import carmel.interpreter.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.io.*;
import java.net.URL;
import javax.swing.*;

public class LoadCarmelSourcePanel extends JPanel {
    protected Action browseAction;
    protected CarmelFileFilter carmelFileFilter = new CarmelFileFilter();

    JFileChooser fileChooser = new JFileChooser();
    BorderLayout borderLayout1 = new BorderLayout();
    JTextField fileNameTextField = new JTextField();
    JButton browseButton = new JButton();
    JLabel messageLabel = new JLabel();

    public LoadCarmelSourcePanel() {
        try {
            jbInit();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }

        browseAction = new AbstractAction("Browse...") {
            public void actionPerformed(ActionEvent event) {
                fileChooser.setSelectedFile(new File(fileNameTextField.getText().trim()));

                if (fileChooser.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
                    fileNameTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
        browseButton.setAction(browseAction);

        fileChooser.addChoosableFileFilter(carmelFileFilter);
        fileChooser.setFileFilter(carmelFileFilter);

        fileNameTextField.requestFocus();

        fileNameTextField.setText("http://www.doc.ic.ac.uk/~lj97/project/test.cml");
    }

    public CarmelSource getCarmelSource() throws IOException {
        String url = fileNameTextField.getText().trim();

        try {
            return new FileCarmelSource(new File(url));
        }
        catch (FileNotFoundException e) {
            return URLCarmelSource.createCarmelSource(new URL(url));
        }
    }

    public void setFileName(String name) {
        fileNameTextField.setText(name);
    }

    void jbInit() throws Exception {
        this.setLayout(borderLayout1);
        browseButton.setText("Browse...");
        messageLabel.setText("Enter file name or URL");
        fileNameTextField.setColumns(40);
        this.add(fileNameTextField, BorderLayout.CENTER);
        this.add(browseButton,  BorderLayout.EAST);
        this.add(messageLabel, BorderLayout.NORTH);
    }

    protected class CarmelFileFilter extends javax.swing.filechooser.FileFilter {
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".cml");
        }

        public String getDescription() { return "Carmel files"; }
    }
}