package carmel.gui;

import carmel.interpreter.*;
import javax.swing.table.*;

public class HeapTableModel extends AbstractTableModel implements HeapListener, PrototypeValueTableModel {

    protected Heap heap;
    protected static final String[] columnNames = new String[] { "Location",    "Type",         "Size" };
    protected static final Class[] columnClasses = new Class[] { Short.class,   String.class,   Short.class };
    protected static final Object[] prototypeValues = new Object[] { "999", "java.lang.ArrayIndexOutOfBoundsExcepton", "999" };

    public HeapTableModel() {}

    public HeapTableModel(Heap heap) {
        setHeap(heap);
    }

    public Heap getHeap() { return heap; }

    public void setHeap(Heap heap) {
        if (this.heap != null) this.heap.removeHeapListener(this);
        this.heap = heap;
        if (heap != null) heap.addHeapListener(this);
        fireTableDataChanged();
    }

    public int getRowCount() { return (heap == null) ? 0 : heap.getMappingCount(); }

    public int getColumnCount() { return 3; }

    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Heap.Mapping mapping = heap.getMapping(rowIndex);

        switch (columnIndex) {
            case 0:     return new Short(mapping.getLocation());
            case 1:     return mapping.getValue().getType().getName();
            case 2:     return new Short(mapping.getValue().getSizeInBytes());
            default:    throw new IndexOutOfBoundsException();
        }
    }

    public void newAllocation(HeapEvent e) {
        int index = e.getIndex();
        fireTableRowsInserted(index, index);
    }

    public Object getPrototypeValue(int column) {
        return prototypeValues[column];
    }
}