package carmel.gui;

import carmel.tree.TreeClass;
import carmel.value.*;
import javax.swing.table.AbstractTableModel;

public class ClassValueTableModel extends AbstractTableModel implements ClassValueListener, PrototypeValueTableModel {

    protected ClassValue classValue;
    protected static final String[] columnNames = new String[] { "Field name", "Value", "Type" };
    protected static final Class[] columnClasses = new Class[] { String.class, Value.class, String.class };
    protected static final Object[] prototypeValues = new Object[] { "fieldName", "undef", "undef" };

    public ClassValueTableModel() {}

    public ClassValueTableModel(ClassValue classValue) {
        setClassValue(classValue);
    }

    public ClassValue getClassValue() { return classValue; }

    public void setClassValue(ClassValue classValue) {
        if (this.classValue != null) this.classValue.removeClassValueListener(this);
        this.classValue = classValue;
        if (classValue != null) classValue.addClassValueListener(this);
        fireTableDataChanged();
    }

    public void fieldChanged(ClassValueEvent e) {
        fireTableCellUpdated(e.getFieldID(), 1);
        fireTableCellUpdated(e.getFieldID(), 2);
    }

    public int getRowCount() { return classValue == null ? 0 : classValue.getParentClass().getFieldIDCount(); }

    public int getColumnCount() { return 3; }

    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: return classValue.getParentClass().getField(rowIndex).getMemberName();
            case 1: return classValue.getFieldValue(rowIndex);
            case 2: return classValue.getFieldValue(rowIndex).getJCVMType().getName();
            default: throw new IndexOutOfBoundsException();
        }
    }

    public Object getPrototypeValue(int column) {
        return prototypeValues[column];
    }
}