package carmel.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.*;

public class ClassPathEditorPanel extends JPanel {
    protected Action addPathAction;

    JFileChooser fileChooser = new JFileChooser();
    BorderLayout borderLayout1 = new BorderLayout();
    JTextField classPathTextField = new JTextField();
    JButton addPathButton = new JButton();
    JLabel messageLabel = new JLabel();

    public ClassPathEditorPanel() {
        try {
            jbInit();
        }
        catch(Exception ex) {
            ex.printStackTrace();
        }

        addPathAction = new AbstractAction("Add Path...") {
            public void actionPerformed(ActionEvent event) {
                if (fileChooser.showDialog(ClassPathEditorPanel.this, "Select") == JFileChooser.APPROVE_OPTION) {
                    StringBuffer classPath = new StringBuffer(classPathTextField.getText().trim());

                    if ((classPath.length() != 0) && (classPath.charAt(classPath.length() - 1) != ';'))
                        classPath.append(';');

                    classPathTextField.setText(classPath.append(fileChooser.getSelectedFile().getAbsolutePath()).toString());
                }
            }
        };

        addPathButton.setAction(addPathAction);

        refreshClassPath();

        classPathTextField.requestFocus();
    }

    public void refreshClassPath() {
        classPathTextField.setText(System.getProperty("java.class.path", "."));
    }

    public void commitChange() {
        System.setProperty("java.class.path", classPathTextField.getText().trim());
    }

    void jbInit() throws Exception {
        this.setLayout(borderLayout1);
        fileChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        classPathTextField.setColumns(40);
        messageLabel.setText("Set classpath");
        this.add(classPathTextField, BorderLayout.CENTER);
        this.add(addPathButton, BorderLayout.EAST);
        this.add(messageLabel, BorderLayout.NORTH);
    }
}