package carmel.gui;

import carmel.interpreter.*;
import javax.swing.table.*;

public class CallStackTableModel extends AbstractTableModel implements CallStackListener, StackFrameListener, PrototypeValueTableModel {

    protected CallStack stack;
    protected static final String[] columnNames = new String[] { "Method",       "File location",    "PC" };
    protected static final Class[] columnClasses = new Class[] { String.class,   String.class,       String.class };
    protected static final Object[] prototypeValues = new Object[] { "test.testtest.ObjectName.methodName(lots.of, parameters, sometimes)", "packageName.cml:999", "handler" };

    public CallStackTableModel() {}

    public CallStackTableModel(CallStack stack) {
        setCallStack(stack);
    }

    public CallStack getCallStack() { return stack; }

    public void setCallStack(CallStack stack) {
        if (this.stack != null) this.stack.removeCallStackListener(this);
        this.stack = stack;
        if (stack != null) stack.addCallStackListener(this);
        fireTableDataChanged();
    }

    public void framePushed(CallStackEvent e) {
        e.getFrame().addStackFrameListener(this);
        fireTableRowsInserted(0, 0);
    }

    public void framePopped(CallStackEvent e) {
        e.getFrame().removeStackFrameListener(this);
        fireTableRowsDeleted(0, 0);
    }

    public void pcChanged(StackFrameEvent e) {
        // assume that pc of the topmost frame is the only one that ever changes
        fireTableCellUpdated(0, 1);
        fireTableCellUpdated(0, 2);
    }

    public void framePopped(StackFrameEvent e) {}

    public int getRowCount() { return stack == null ? 0 : stack.getDepth(); }

    public int getColumnCount() { return 3; }

    public String getColumnName(int columnIndex) {
        return columnNames[columnIndex];
    }

    public Class getColumnClass(int columnIndex) {
        return columnClasses[columnIndex];
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        StackFrame frame = stack.getFrame(rowIndex);

        switch (columnIndex) {
            case 0: return frame.getMethod().getNameWithTypes();
            case 1: return frame.getCarmelSource().getName() + ':' + frame.getPC().getLineNumber();
            case 2: return frame.getPC().getAddress();
            default: throw new IndexOutOfBoundsException();
        }
    }

    public Object getPrototypeValue(int column) {
        return prototypeValues[column];
    }
}