/*
 * Decompiled with CFR 0.152.
 */
package carmel.value;

import carmel.interpreter.Heap;
import carmel.interpreter.VerificationException;
import carmel.tree.TreeClass;
import carmel.tree.TreeField;
import carmel.type.TypeException;
import carmel.value.ClassValueEvent;
import carmel.value.ClassValueListener;
import carmel.value.NonNullReferenceValue;
import carmel.value.Value;
import javax.swing.event.EventListenerList;

public class ClassValue
extends NonNullReferenceValue {
    public boolean isInit = false;
    protected Value[] fieldValues;
    protected boolean[] fieldInit;
    protected int sizeInBytes;
    protected TreeClass parentClass;
    protected EventListenerList listeners = new EventListenerList();
    static Class class$carmel$value$ClassValueListener;

    public ClassValue(Heap heap, TreeClass type) {
        super(type);
        this.parentClass = type;
        int fieldIDCount = this.parentClass.getFieldIDCount();
        this.fieldValues = new Value[fieldIDCount];
        this.fieldInit = new boolean[fieldIDCount];
        int i = fieldIDCount;
        while (--i >= 0) {
            this.fieldValues[i] = this.parentClass.getField(i).getType().getJCVMType().createDefaultValue();
        }
        this.heapLocation = heap.allocate(this);
    }

    public Value getFieldValue(int fieldID) {
        return this.fieldValues[fieldID];
    }

    public void setFieldValue(int fieldID, Value value) throws VerificationException, TypeException {
        TreeField field = this.parentClass.getField(fieldID);
        field.getType().checkAssignableFrom(value.getType());
        if (field.isFinal()) {
            if (this.fieldInit[fieldID]) {
                throw new VerificationException("Attempt to set the value of a final field for the second time");
            }
            this.fieldInit[fieldID] = true;
        }
        this.fieldValues[fieldID] = value;
        this.fireFieldChanged(fieldID);
    }

    public short getSizeInBytes() {
        return (short)(1 + this.parentClass.getFieldsSizeInBytes());
    }

    public TreeClass getParentClass() {
        return this.parentClass;
    }

    public void addClassValueListener(ClassValueListener l) {
        this.listeners.add(class$carmel$value$ClassValueListener == null ? (class$carmel$value$ClassValueListener = ClassValue.class$("carmel.value.ClassValueListener")) : class$carmel$value$ClassValueListener, l);
    }

    public void removeClassValueListener(ClassValueListener l) {
        this.listeners.remove(class$carmel$value$ClassValueListener == null ? (class$carmel$value$ClassValueListener = ClassValue.class$("carmel.value.ClassValueListener")) : class$carmel$value$ClassValueListener, l);
    }

    protected void fireFieldChanged(int index) {
        ClassValueEvent e = new ClassValueEvent(this, index);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$value$ClassValueListener == null ? ClassValue.class$("carmel.value.ClassValueListener") : class$carmel$value$ClassValueListener)) continue;
            ((ClassValueListener)list[i + 1]).fieldChanged(e);
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

