/*
 * Decompiled with CFR 0.152.
 */
package carmel.value;

import carmel.type.ByteType;
import carmel.type.JCVMByteType;
import carmel.type.TypeException;
import carmel.value.NumericValue;
import carmel.value.ShortValue;

public class ByteValue
extends NumericValue {
    protected byte value;

    public ByteValue() {
        this(0);
    }

    public ByteValue(byte value) {
        super(ByteType.TYPE);
        this.value = value;
    }

    public byte getValue() {
        return this.value;
    }

    public int getValueAsInt() {
        return this.value;
    }

    public void setValue(byte value) {
        this.value = value;
    }

    public ShortValue toShort() {
        return new ShortValue(this.value);
    }

    public static ByteValue fromShort(ShortValue v) throws TypeException {
        try {
            ByteValue byteValue = (ByteValue)JCVMByteType.TYPE.createValue(v.value);
            return byteValue;
        }
        catch (IllegalArgumentException e) {
            throw new TypeException("Value contained in short value is not a byte");
        }
    }

    public int compareTo(Object o) {
        return this.value - ((ByteValue)o).value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o instanceof ByteValue && this.value == ((ByteValue)o).value;
    }

    public String toString() {
        return Byte.toString(this.value);
    }
}

