/*
 * Decompiled with CFR 0.152.
 */
package carmel.value;

import carmel.interpreter.Heap;
import carmel.interpreter.StackEntryList;
import carmel.interpreter.StackEntryListListener;
import carmel.type.ArrayType;
import carmel.type.ComponentType;
import carmel.type.JCVMOperandType;
import carmel.type.TypeException;
import carmel.value.ArrayValueEvent;
import carmel.value.ArrayValueListener;
import carmel.value.NonNullReferenceValue;
import carmel.value.StackEntry;
import carmel.value.Value;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public class ArrayValue
extends NonNullReferenceValue
implements StackEntryList {
    protected Value[] values;
    protected ComponentType componentType;
    protected short length;
    protected EventListenerList listeners = new EventListenerList();
    static Class class$carmel$value$ArrayValueListener;

    protected ArrayValue(short length, Heap heap, ArrayType type) {
        super(type);
        this.length = length;
        this.values = new Value[length];
        this.componentType = type.getComponentType();
        this.heapLocation = heap.allocate(this);
    }

    public ArrayValue(Heap heap, ArrayType type, short length) throws NegativeArraySizeException {
        this(length, heap, type);
        JCVMOperandType elementJCVMType = this.componentType.getJCVMType();
        while ((length = (short)(length - 1)) >= 0) {
            this.values[length] = elementJCVMType.createDefaultValue();
        }
    }

    public ArrayValue(Heap heap, ArrayType type, List values) {
        this((short)values.size(), heap, type);
        int index = 0;
        Iterator i = values.iterator();
        while (i.hasNext()) {
            this.values[index++] = (Value)i.next();
        }
    }

    public short getLength() {
        return this.length;
    }

    public short getSizeInBytes() {
        return (short)(this.length * this.componentType.getSizeInBytes() + 2);
    }

    public Value getValueAt(int index) throws ArrayIndexOutOfBoundsException {
        return this.values[index];
    }

    public void setValueAt(int index, Value value) throws TypeException, ArrayIndexOutOfBoundsException {
        this.componentType.checkAssignableFrom(value.getType());
        this.values[index] = value;
        this.fireElementChanged(index);
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public void addStackEntryListListener(StackEntryListListener l) {
        this.listeners.add(class$carmel$value$ArrayValueListener == null ? (class$carmel$value$ArrayValueListener = ArrayValue.class$("carmel.value.ArrayValueListener")) : class$carmel$value$ArrayValueListener, l);
    }

    public void removeStackEntryListListener(StackEntryListListener l) {
        this.listeners.remove(class$carmel$value$ArrayValueListener == null ? (class$carmel$value$ArrayValueListener = ArrayValue.class$("carmel.value.ArrayValueListener")) : class$carmel$value$ArrayValueListener, l);
    }

    protected void fireElementChanged(int index) {
        ArrayValueEvent e = new ArrayValueEvent(this, index);
        Object[] list = this.listeners.getListenerList();
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != (class$carmel$value$ArrayValueListener == null ? ArrayValue.class$("carmel.value.ArrayValueListener") : class$carmel$value$ArrayValueListener)) continue;
            ((ArrayValueListener)list[i + 1]).elementChanged(e);
        }
    }

    public int getEntryListSize() {
        return this.length;
    }

    public StackEntry getEntryNoVerification(int index) {
        return this.values[index];
    }

    public int hashCode() {
        return this.componentType.hashCode() + Arrays.asList(this.values).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayValue)) {
            return false;
        }
        ArrayValue v = (ArrayValue)o;
        return this.componentType == v.componentType && Arrays.equals(this.values, v.values);
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

