/*
 * Decompiled with CFR 0.152.
 */
package carmel.type;

import carmel.type.JCVMNumericType;
import carmel.type.TypeException;
import carmel.value.NumericValue;
import carmel.value.ShortValue;
import carmel.value.Value;

public class JCVMShortType
extends JCVMNumericType {
    public static final JCVMShortType TYPE = new JCVMShortType();

    private JCVMShortType() {
    }

    public Value createDefaultValue() {
        return new ShortValue();
    }

    public NumericValue to(int value) {
        return new ShortValue((short)value);
    }

    public NumericValue createValue(int value) throws IllegalArgumentException {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Value out of range for short");
        }
        return this.to(value);
    }

    public String getName() {
        return "s";
    }

    public NumericValue applyUnaryNumOp(int operator, NumericValue value, JCVMNumericType resultType) throws TypeException {
        this.checkType(value);
        short v = ((ShortValue)value).getValue();
        switch (operator) {
            case -1: {
                return new ShortValue(-v);
            }
            case -2: {
                return resultType.to(v);
            }
            case -3: {
                return resultType.to((byte)v);
            }
        }
        throw new InternalError("Unknown binary numeric operator: ".concat(String.valueOf(String.valueOf(operator))));
    }

    public NumericValue applyBinaryNumOp(int operator, NumericValue value1, NumericValue value2) throws TypeException {
        int result;
        this.checkType(value1);
        this.checkType(value2);
        short v1 = ((ShortValue)value1).getValue();
        short v2 = ((ShortValue)value2).getValue();
        switch (operator) {
            case 0: {
                result = v1 + v2;
                break;
            }
            case 1: {
                result = v1 - v2;
                break;
            }
            case 2: {
                result = v1 * v2;
                break;
            }
            case 3: {
                result = v1 / v2;
                break;
            }
            case 4: {
                result = v1 % v2;
                break;
            }
            case 5: {
                result = v1 & v2;
                break;
            }
            case 6: {
                result = v1 | v2;
                break;
            }
            case 7: {
                result = v1 ^ v2;
                break;
            }
            case 8: {
                result = v1 << v2;
                break;
            }
            case 9: {
                result = v1 >> v2;
                break;
            }
            case 10: {
                result = v1 >>> v2;
                break;
            }
            case 11: {
                result = v1 == v2 ? 0 : (v1 > v2 ? 1 : -1);
                break;
            }
            default: {
                throw new InternalError("Unknown binary numeric operator: ".concat(String.valueOf(String.valueOf(operator))));
            }
        }
        return new ShortValue((short)result);
    }
}

