/*
 * Decompiled with CFR 0.152.
 */
package carmel.type;

import carmel.type.JCVMOperandType;
import carmel.type.TypeException;
import carmel.value.NumericValue;
import carmel.value.Value;

public abstract class JCVMNumericType
extends JCVMOperandType {
    public static final int NEG = -1;
    public static final int TO = -2;
    public static final int TOB = -3;
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int REM = 4;
    public static final int AND = 5;
    public static final int OR = 6;
    public static final int XOR = 7;
    public static final int SHL = 8;
    public static final int SHR = 9;
    public static final int USHR = 10;
    public static final int CMP = 11;
    public static final int GT = 0;
    public static final int LT = 1;
    public static final int LE = 3;
    public static final int GE = 4;

    public abstract NumericValue applyUnaryNumOp(int var1, NumericValue var2, JCVMNumericType var3) throws TypeException;

    public abstract NumericValue applyBinaryNumOp(int var1, NumericValue var2, NumericValue var3) throws TypeException;

    public abstract NumericValue createValue(int var1) throws IllegalArgumentException;

    public abstract NumericValue to(int var1);

    public boolean applyCondOp(int operator, Value value1, Value value2) throws TypeException {
        this.checkType(value1);
        this.checkType(value2);
        int result = ((NumericValue)value1).compareTo(value2);
        switch (operator) {
            case 2: {
                return result == 0;
            }
            case 5: {
                return result != 0;
            }
            case 0: {
                return result > 0;
            }
            case 1: {
                return result < 0;
            }
            case 3: {
                return result <= 0;
            }
            case 4: {
                return result >= 0;
            }
        }
        throw new IllegalArgumentException("Unknown conditional operator: ".concat(String.valueOf(String.valueOf(operator))));
    }

    static {
        NEG = -1;
        TO = -2;
        TOB = -3;
        ADD = 0;
        SUB = 1;
        MUL = 2;
        DIV = 3;
        REM = 4;
        AND = 5;
        OR = 6;
        XOR = 7;
        SHL = 8;
        SHR = 9;
        USHR = 10;
        CMP = 11;
        GT = 0;
        LT = 1;
        LE = 3;
        GE = 4;
    }
}

